void tran_frame( void );
void     camera( void );
void        i2c( char, int, int, char );
void      write( char );
void       read( int );
void      start( void );
void       stop( void );

const char      WRITE = 0x42;
const char       READ = 0x43;
const char   TWO-WIRE = 0;
const char THREE-WIRE = 1;
unsigned char data[201];
unsigned short int byte = 0x00;

void reset( void )
{
    OV7670.stop();
    OV7670.frequency( 300000 );
    wait_ms( 10 );
    
    i2c( WRITE, 0x12, THREE-WIRE, 0x80 );    //reset
}

void tran_frame( void )
{
    OV7670.stop();
    OV7670.frequency( 200000 );
    wait_ms( 10 );
    
    i2c( WRITE, 0x12, THREE-WIRE, 0x80 );    //reset
    wait_ms( 10 );
    /*i2c( WRITE, 0x12, 1, 0x08 );
    wait_ms( 10 );
    //i2c( WRITE, 0x18, 1, 0x27 );    //HSTOP
    wait_ms( 10 );
    //i2c( WRITE, 0x1A, 1, 0x27 );    //VSTOP*/
    //i2c( WRITE, 0x11, 1, 0x83 );    //48[MHz] -> 12[MHz]
    //i2c( WRITE, 0x11, 1, 0x80 );    //24[MHz] -> 24[MHz]
}

void camera( void )
{
    OV7670.stop();
    
    wait_ms( 10 );
    for( int a = 0; a < 202; a ++ )
    {
        i2c( WRITE, a, TWO-WIRE, 0 );
        i2c(  READ, a, TWO-WIRE, 0 );
    }
    for( int b = 1; b <= 202; b ++ )
    {
        device.printf("|%s : %2x ", address_name[b], data[b - 1]);
        if( ( b % 6 ) == 0 )    device.printf("|\n");
        if( b == 202 )  device.printf("|\n");
    }
}

void i2c( char mode, int a, int flag, char data )
{
    OV7670.start();
    
    while( !( OV7670.write( mode ) ) );
    wait_ms( 10 );
    
    if( mode == 0x42 ) 
    {
        write( a );
        if( flag == 1 ) write( data );
    }
    else if( mode == 0x43 ) read( a );
    
    OV7670.stop();
    wait_ms( 10 );
}

void write( char reg_add )
{
    while( !( OV7670.write( reg_add ) ) );
}

void read( int a )
{
    data[a] = OV7670.read( 0 );
}