#include "mbed.h"
float Calculate_Period(unsigned int Freq);
PwmOut led(LED_GREEN);
PwmOut Sound(D7);
Serial pc(USBTX, USBRX);
#define A 440
#define As 466
#define B 493
#define C 523
#define Cs 554
#define D 587
#define Ds 622
#define E 659
#define F 698
#define Fs 739
#define G 783
#define Gs 830
#define R 0
const unsigned int song1 [] =       {C,C,C,D,E,E,D,E,F,G,C*2,C*2,C*2,G,G,G,E,E,E,C,C,C,G,F,E,D,C,R };
const unsigned int notelength1 [] = {3,3,2,1,3,2,1,2,1,6,1  ,1  ,1  ,1,1,1,1,1,1,1,1,1,2,1,2,1,6,16};
const unsigned int song2 [] =       {As,Cs,C,F,As,As,As,Cs,C,F,As,As,As,Cs,C,F,As,As,As,Cs,C,F,As,As,As,Cs,C,F,As*2,As*2,As*2,As*2,As*2,As*2,R,As,Cs,C,F,As,As,R,As,Cs,C,F,As,As,R,As,Cs,C,F,As,As,R,As,Cs,C,F,As,As,R,As,Cs,C,F,As,As,As,Cs,C,F,As,As,As,Cs,C,F,Fs/2,Fs/2,Gs/2,Cs,C,F,As,As,As,Cs,C,F,As,As,As,Cs,C,F,As,F/2,As,F/2,As,Cs,C,F,F,F,As,Cs,C,F,Cs,F/2,As,F/2,As,Cs,C,F,Gs,As,Ds,As,As*2,Cs,C,F,Gs,As,Ds,As,Ds,F,Gs,C*2,Cs*2,C*2,Gs,F,C,Gs,As,As,F/2,As,As,Cs,Fs/2,As,F/2,C,As,F/2,As,As,F/2,Cs,As,Fs/2,As,Cs,F,Cs,As,Cs,F,Fs/2,As,Cs,F,Cs,As,As*2,F,Cs,F,As,As*2,Fs/2,As,Gs/2,As,C,Cs,As,Fs/2,As,As,Cs,Fs/2,As*2,Fs,Cs,As,Cs,C,As,C,C,Cs,Fs/2,As,Cs,C,As,C,Gs/2,Cs*2,Fs,As*2,C,F,C,F,C,F,Cs*2,Fs,C*2,As,As,F/2,As,As,Cs,Fs/2,As,F/2,C,As,F/2,As,As,F/2,Cs,As,Fs/2,As,Cs,F,Cs,As,Cs,F,Fs/2,As,Cs,F,Cs,Cs,As*2,F,Cs,F,As,As*2,Fs/2,As,Gs/2,As,C,Cs,As,Fs/2,Ds,F,Fs,Gs,Cs,As,Fs/2,C,Cs,F,Fs,Gs,As*2,Cs,Cs,As,Ds,F,Ds,F,Fs,Gs,Cs,C,Ds,F,Gs*2,Gs*2,G*2,Fs*2,F*2,E*2,Ds*2,D*2,Cs*2,C*2,B*2,As*2,A*2,Gs,G,Fs,F,E,Ds,D,Cs,C,B,As,A,Gs/2,G/2,Fs/2,F/2,E/2,Ds/2,D/2,Cs/2,C/2,R,Cs/2,F/2,C/2,Cs/2,Gs/3,As/2,C/2,As/2,Cs/2,F/2,C/2,Cs/2,Gs/3,As/2,C/2,As/2,Cs/2,F/2,C/2,Cs/2,Gs/3,As/2,C/2,As/2,Cs/2,F/2,C/2,Cs/2,Gs/3,As/2,C/2,As/2,Cs/2,Fs/3,C/2,Cs/2,Gs/3,As/2,C/2,As/2,Fs/3,F/2,C/2,Cs/2,Gs/3,As/2,C/2,As/2,Cs/2,Gs/3,C/2,Cs/2,Gs/3,As/2,C/2,As/2,Gs/3,F/2,C/2,Cs/2,Ds/3,As/2,C/2,As/2,As*2,As,As*2,As,As*2,As,As*2,As,Cs*2,As*2,Cs*2,As*2,Cs*2,As*2,Cs*2,As*2,Cs,F/2,Cs,F/2,Cs,F/2,Cs,F/2,Cs*3,As*2,Cs*3,As*2,Cs*3,As*2,Cs*3,Cs,R};
const unsigned int notelength2 [] = {4 ,4 ,4,4,8 ,4 ,4 ,4 ,4,4,8 ,4 ,4 ,4 ,4,4,8 ,4 ,4 ,4 ,4,4,8 ,4 ,4 ,4 ,4,4,8   ,4   ,8   ,4   ,8   ,4   ,4,4 ,4 ,4,4,8 ,4 ,4,4 ,4 ,4,4,8 ,4 ,4,4 ,4 ,4,4,8 ,4 ,4,4 ,4 ,4,4,8 ,4 ,4,4 ,4 ,4,4,8 ,8 ,4 ,4 ,4,4,8 ,8 ,4 ,4 ,4,4,8   ,8   ,4   ,4 ,4,4,8 ,8 ,4 ,4 ,4,4,8 ,8 ,4 ,4 ,4,4,4 ,4  ,4 ,4  ,4 ,4 ,4,4,8,8,4 ,4 ,4,4,4 ,4  ,4 ,4  ,4 ,4 ,4,4,4 ,4 ,4 ,4 ,4   ,4 ,4,4,4 ,4 ,4 ,4 ,8 ,8,8 ,8  ,4   ,4  ,4 ,4,4,8 ,4 ,2 ,2  ,4 ,4 ,4 ,4   ,4 ,4  ,4,2 ,2  ,4 ,2 ,2  ,4 ,2 ,2   ,8 ,4 ,2,2 ,4 ,4 ,4,4   ,2 ,2 ,2,2 ,4 ,2   ,2,4 ,2,2 ,4   ,4   ,2 ,2   ,2 ,2,4 ,2 ,2   ,4 ,4 ,4 ,4   ,2   ,2 ,2 ,2 ,4 ,2,2 ,4,4,4 ,4   ,8 ,4 ,2,2 ,4,4   ,4   ,4 ,8   ,4,2,2,2,2,4,4   ,4 ,8  ,4 ,2 ,2  ,4 ,4 ,4 ,4   ,4 ,4  ,4,2 ,2  ,4 ,2 ,2  ,4 ,2 ,2   ,8 ,4 ,2,2 ,4 ,4 ,4,4   ,2 ,2 ,2,2 ,4 ,2   ,2,4 ,2,2 ,4   ,4   ,2 ,2   ,2 ,2,4 ,2 ,2   ,4 ,4,4 ,4 ,4 ,2 ,2   ,4,4 ,4,4 ,4 ,4   ,4 ,2 ,2 ,4 ,4,4 ,4,4 ,4 ,4 ,4,4 ,4,8   ,1   ,1  ,1   ,1  ,1  ,1   ,1  ,1   ,1  ,1  ,1   ,1  ,1 ,1,1 ,1,1,1 ,1,1 ,1,1,1 ,1,1   ,1  ,1   ,1  ,1  ,1   ,1  ,1   ,1  ,1,4   ,4  ,4  ,4   ,4   ,4   ,4  ,4   ,4   ,4  ,4  ,4   ,4   ,4   ,4  ,4   ,4   ,4  ,4  ,4   ,4   ,4   ,4  ,4   ,4   ,4  ,4  ,4   ,4   ,4   ,4  ,4   ,4   ,4   ,4  ,4   ,4   ,4   ,4  ,4   ,4   ,4  ,4  ,4   ,4   ,4   ,4  ,4   ,4   ,4   ,4  ,4   ,4   ,4   ,4  ,4   ,4   ,4  ,4  ,4   ,4   ,4   ,4  ,4   ,4   ,4 ,4   ,4 ,4   ,4 ,4   ,4 ,4   ,4   ,4   ,4   ,4   ,4   ,4   ,4   ,4 ,4  ,4 ,4  ,4 ,4  ,4 ,4  ,4   ,4   ,4   ,4   ,4   ,4   ,4   ,4 ,1};
const unsigned char line1[] = "~~~~~~~~~~~~~~~~~~~~~~~\r\n";
const unsigned char line2[] = "~~ 1 Row Row         ~~\r\n";
const unsigned char line3[] = "~~ 2 Focus - Chipzel ~~\r\n";
const unsigned char line4[] = "~~~~~~~~~~~~~~~~~~~~~~~\r\n";

int main(void) {

    int select=0;
    pc.printf((char*)line1);
    pc.printf((char*)line2);
    pc.printf((char*)line3);
    pc.printf((char*)line4);
    pc.scanf("%d",&select);
    pc.printf("%d\r\n,select");
    while (true)
 {
        if(select !=0 && select < 2)
        {
            pc.printf("You Selected: %d\r\n",select);
        }
        else
        {
            pc.printf("Select a value between 1 and 2\r\n");
        }
        switch (select)
        {
            case 1:
                for(int i = 0; i<sizeof(song1)/4; i++)
                {
                Sound.period(Calculate_Period(song1[i]));   
                Sound = .5;
                for(int t = 0; t < notelength1[i];t++)
                {
                    wait(.1);
     }
 }
 break;

     case 2:
 for(int i = 0; i<sizeof(song2)/4; i++)
    {
    Sound.period(Calculate_Period(song2[i]));   
    Sound = .5;
    for(int t = 0; t < notelength2[i];t++)
     {
     wait(.05);
     }
 }
 
 break;
 default:
 break;
 }
    
    pc.printf("you may select another song.\r\n");
select = 0;
pc.scanf("%d",&select);
 }
 }
    
float Calculate_Period(unsigned int Freq)
{       
return( 1/(float)Freq);   
}
