#include "mbed.h"

#define MAX_BUFFER 64

//modbus funtion code
enum {
  FC_READ_COILS = 1,
  FC_READ_DISCRETE_INPUT = 2,
  FC_WRITE_COIL = 5};
  
  enum {
  CB_READ_COILS = 0,
  CB_WRITE_COIL};
  
  enum {
  COIL_OFF = 0x0000,
  COIL_ON = 0xff00};
  
  //class modbus
  class Modbus {
public:
    Modbus(uint8_t unitID, int ctrlPin);
    Modbus(Stream &serial, uint8_t unitID, int ctrlPin);
    void begin(unsigned long boud);
    int poll();
    void writeCoilToBuffer(int offset, uint16_t state);
    void writeStringToBuffer(int offset, uint8_t *str, uint8_t length);

private:
    Stream &serial;
    uint32_t timeout;
    uint32_t last_receive_time;
    uint16_t last_receive_len;
    uint16_t calcCRC(uint8_t *buf, int length);

    int ctrlPin;
    uint8_t unitID;
    uint8_t bufIn[MAX_BUFFER];
    uint8_t bufOut[MAX_BUFFER];
};