#include "mbed.h"
#include "note.h"
#include "Servo.h"
#include "Rtc_Ds1307.h"

DigitalIn bottone(p14);
DigitalOut ledR(p25);
DigitalOut ledG(p24);
DigitalOut ledB(p26);
PwmOut piezo(p22);
Servo myservo1(p23);
Servo myservo2(p21);
Rtc_Ds1307 rtc( p9,p10 );
Serial pc(USBTX, USBRX, "pc");

int c=0;
int a=0;
int b=0;
int f=0;
int orario_pastiglia=0, ultimo_giorno=0;
int flag=0;

void suono(int frequenza, int beat);
void movimento_servi();
void seriale(Rtc_Ds1307::Time_rtc time);

int main()
{
    Rtc_Ds1307::Time_rtc time= {};
    ledB=1;
    suono(NOTE_B4,1);
    wait(0.5);
    seriale(time);
    while(1) {

        if(bottone) {
            flag=0;
            ledG=1;
            suono(NOTE_B4,8);
            wait(0.1);
            do {
                flag=0;
                wait_ms(1);
                c++;
                if(c++>=10000) {
                    ledG=0;
                    ledR=1;
                    suono(NOTE_C5,1);
                    flag=1;
                } else if(bottone) flag=2;
            } while(flag==0);
            ledR=0;
            if(flag==2) {
                movimento_servi();
            }else if(flag==1){seriale(time);}
        }


        if(ultimo_giorno!=time.date) {
            if(orario_pastiglia==time.hour) {
                movimento_servi();
                ultimo_giorno=time.date;
            } else if(time.hour==orario_pastiglia-1 || time.hour>orario_pastiglia) {
                movimento_servi();
                ultimo_giorno=time.date;
            }
        }//gia fatto oggi?

        wait_ms(1);
    }
}
/*
pc.printf("a=%d03", a);
pc.printf("b=%d03", b);
*/
void movimento_servi()
{
    if(a<2) {
        a++;
        pc.printf("a=%d03", a);
    } else if(a>=2) {
        for(float i=0; i<30; i++) {
            myservo1=i;
            wait(0.1);
            a=0;
            b++;
            pc.printf("b=%d03", b);
        }
    }
    if(b==5) {
        for(float i=180; i<0; i++)
            myservo1=i;
        wait(0.1);
        b=0;
    }


    if(f==0) {
        for(float i=0; i<30; i++)
            myservo2=i;
        wait(0.1);
        f++;
    } else if(f==1)
        for(float i=0; i<60; i++)
            myservo2=i;
    wait(0.1);
    f++;
    if(f==3) {
        for(float i=60; i<0; i--)
            myservo2=i;
        wait(0.1);
        f=0;
    }
}

void suono(int frequenza, int beat)
{
    piezo.period(1.0 / frequenza);
    piezo.write(0.5);
    wait(1.0 / beat);
    piezo.write(0);
    wait(0.05);
}

void seriale(Rtc_Ds1307::Time_rtc time)
{
    int s;
    do{
    pc.printf("**********************************\n");
    pc.printf("* Menu :                         *\n");
    pc.printf("* 1 - imposta ora orologio       *\n");
    pc.printf("* 2 - imposta ora pastiglia      *\n");
    pc.printf("* 3 - mostra settaggi            *\n");
    pc.printf("* 4 - esci                       *\n");
    pc.scanf("%d", &s);
    switch(s) {
        case 1:
            pc.printf("Giorno (0..31)");
            pc.scanf("%d", &time.date);
            pc.printf("Mese (1..12)");
            pc.scanf("%d", &time.mon);
            pc.printf("Anno ");
            pc.scanf("%d", &time.year);
            pc.printf("Ore (0..23)");
            pc.scanf("%d", &time.hour);
            pc.printf("Minuti (0..59)");
            pc.scanf("%d", &time.min);
            pc.printf("Secondi (0..59)");
            pc.scanf("%d", &time.sec);
            break;
        case 2:
            pc.printf("Orario pastiglia");
            pc.scanf("%d", &orario_pastiglia);
            break;
        case 3:
            pc.printf("Ora sono le : %02d:%02d:%02d del %02d/%02d/%04d \n", time.hour, time.min, time.sec, time.mon, time.date, time.year);
            break;
        case 4: pc.printf("Uscita");break;
    }
    }while(s!=4);
}
