#ifndef MyI2C_H
#define MyI2C_H

#include "mbed.h"
 
#define I2C_ACK  true
#define I2C_NACK false
 
#define I2C_WRITE 0
#define I2C_READ 1
 
extern bool I2C0AddressResponds(uint8_t);
 
class MyI2C 
{
private:
    bool waitclock(void);
public:
    //void frequency(uint32_t f);
    void start(void);
    void stop(void);
    uint8_t blockread(uint8_t r, char* b, uint8_t);
    uint8_t read(uint8_t r);
    bool blockwrite(uint8_t a, const char* b, uint8_t l);
    uint8_t write(uint8_t d);
};
 
#endif