#include "mbed.h"
#include "BLEDevice.h"
#include "TxPower.h"

BLEDevice ble;

void disconnectionCallback(Gap::Handle_t handle, Gap::DisconnectionReason_t reason)
{
    ble.startAdvertising(); // restart advertising
}

int main() {
 
    ble.init();
    ble.onDisconnection(disconnectionCallback);
    
    TxPowerService tx(ble, -30); // setting up the service and assigning an initial value
    tx.updateTxPower(-10);    //changing the initial value just for testing ....       
     
    ble.accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED | GapAdvertisingData::LE_GENERAL_DISCOVERABLE);
    ble.setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    ble.setAdvertisingInterval(Gap::MSEC_TO_ADVERTISEMENT_DURATION_UNITS(1000)); 
    ble.startAdvertising();
     
     while (true) {
    
        ble.waitForEvent();
         
    }
 
}
