#ifndef DCM_H
#define DCM_H

#include "mbed.h"

#define GRAVITY 4096
#define Kp_ROLLPITCH 1.515/GRAVITY //1.515
#define Ki_ROLLPITCH 0.00101/GRAVITY //0.00101


class DCM{

public:
   
 DCM(void);
   
float G_Dt;

float roll;

float pitch;

float yaw;

void Update_DCM(float dt,float a, float b, float c, float d, float e, float f);

float DCM_Matrix[3][3]; 

float Update_Matrix[3][3];

float Temporary_Matrix[3][3];

private:

float Accel_Vector[3]; //Store the acceleration in a vector
float Gyro_Vector[3];//Store the gyros rutn rate in a vector
float Omega_Vector[3]; //Corrected Gyro_Vector data
float Omega_P[3];//Omega Proportional correction
float Omega_I[3];//Omega Integrator
float Omega[3];
float errorRollPitch[3]; 


float constrain(float x, float a, float b);

void Normalize(void);

void Drift_correction(void);

void Matrix_update(float GyroX,float GyroY,float GyroZ, float AccX, float AccY, float AccZ);

void Euler_angles(void);

};

#endif