#ifndef MPU6050_H
#define MPU6050_H

#include "mbed.h"
#include "MyI2C.h"
#include "MAF.h"

#define MPU_ADDRESS 0x68
#define GyroScale  16.4f
#define AccScale   4096
#define ToRad(x) (x*0.01745329252)  // *pi/180
#define ToDeg(x) (x*57.2957795131)  // *180/pi

extern MyI2C I2C0;

class MPU6050
{

public:

 MPU6050(void);
float filtered_Gyro[3],filtered_Acc[3];
float Scaled_GyroX,Scaled_GyroY,Scaled_GyroZ;
float Scaled_AccX,Scaled_AccY,Scaled_AccZ;
int Raw_AccX,Raw_AccY,Raw_AccZ;
float GyroOffset[3],AccOffset[3];
float accangle[2];
float Acceleration_Magnitude;
bool Panic;


bool CheckConnection(void);

void MPU_Setup(void);

void ScaledGyro(void);

void ScaledAcc(void);

void RawAcc(void);

void CalibrateGyro(void);

void CalibrateAcc(void);

void GyroRate(void);

void Acc(void);

void filterGyro(void);

void filterAcc(void);

void AccAngle(void);

private:

MAF filter_AccX,filter_AccY,filter_AccZ; // Moving Average Filter Initiallization 

MAF filter_GyroX,filter_GyroY,filter_GyroZ;

void write(char reg,char data);

int read (char reg);

};

#endif