#ifndef BMP085_H
#define BMP085_H

#include "Std_Types.h"
#include "MyI2C.h"

#define BMP_ADDRESS 0x77
#define OSS 3

extern MyI2C I2C0;

class BMP085{

 public:
 BMP085();
 void Calibrate(void);
 void readUT_Flag(void);
 void readUP_Flag(void);
 uint16 readUT(void);
 uint32 readUP(void);
 int16 read_Temperature(void);
 int32 read_Pressure(void);
 private:
 
 int16 AC1,AC2,AC3,AC4,AC5,AC6;
 int16 B1,B2;
 int16 MB,MC,MD;
 int32 B5;
 
 void write(char reg,char data);

 int16 read (char reg);
 
 uint8 readInt (char reg);
 
};
#endif