#include "BMP085.h"

BMP085::BMP085(){}

void BMP085::write(char reg,char data){
    
    char tx[2]={reg,data};

    I2C0.blockwrite((BMP_ADDRESS << 1)&0xFE, tx, 2);

 }

int16 BMP085::read (char reg){

    char tx = reg;
    char rx[2];

    I2C0.blockwrite((BMP_ADDRESS << 1)&0xFE, &tx, 1);

    I2C0.blockread((BMP_ADDRESS << 1)|0x01, rx, 2);

    int16 output = ((int16) rx[0] << 8) | ((int16) rx[1]);
    return output;
}

uint8 BMP085::readInt (char reg){

    char tx = reg;
    char rx;

    I2C0.blockwrite((BMP_ADDRESS << 1)&0xFE, &tx, 1);

    I2C0.blockread((BMP_ADDRESS << 1)|0x01, &rx, 1);
    
    return rx;
}

// Get Calibration Values
void BMP085::Calibrate(void){

  AC1 = read(0xAA);
  AC2 = read(0xAC);
  AC3 = read(0xAE);
  AC4 = read(0xB0);
  AC5 = read(0xB2);
  AC6 = read(0xB4);
  B1  = read(0xB6);
  B2  = read(0xB8);
  MB  = read(0xBA);
  MC  = read(0xBC);
  MD  = read(0xBE);
 
}

//Uncompensated temperature takes 4.5ms to read, so we'll just send a read flag and read the data the next cycle since our control loop repeats every 5 ms 

void BMP085::readUT_Flag(void){

  write(0xF4,0x2E);
}

// reading uncompensated Pressure depends on our resolution setting, we'll select ultra high resolution setting so the delay will be 25.5ms (5 iterations);

void BMP085::readUP_Flag(void){

  write(0xF4,(0x34 + (OSS<<6)));
}

uint16 BMP085::readUT(void){
  
  uint16 ut = (uint16)read(0xF6);
  
  return ut;
  
}
uint32 BMP085::readUP(void){
  
  uint32 up = (((uint32) readInt(0xF6) << 16) | ((uint32) readInt(0xF7) << 8) | (uint32) readInt(0xF8)) >> (8-OSS);
  
  return up;
}

int16 BMP085::read_Temperature(void){

 int32 X1,X2;
 
 X1 = (((int32)readUT() - (int32)AC6)*(int32)AC5) >> 15;
 X2 = ((int32)MC << 11)/(X1 + MD);
 
 B5 = X1+X2;
 
 return ((B5 + 8)>>4); 
}

int32 BMP085::read_Pressure(void){
  
  int32 X1, X2, X3, B3, B6, p;
  uint32 B4, B7;
  
  B6 = B5 - 4000;
  // Calculate B3
  X1 = (B2 * (B6 * B6)>>12)>>11;
  X2 = (AC2 * B6)>>11;
  X3 = X1 + X2;
  B3 = (((((int32)AC1)*4 + X3)<<OSS) + 2)>>2;
  
  // Calculate B4
  X1 = (AC3 * B6)>>13;
  X2 = (B1 * ((B6 * B6)>>12))>>16;
  X3 = ((X1 + X2) + 2)>>2;
  B4 = (AC4 * (uint32)(X3 + 32768))>>15;
  
  B7 = ((uint32)(readUP() - B3) * (50000>>OSS));
  
  if (B7 < (uint32)0x80000000)
  {
    p = (B7<<1)/B4;
    }
  else{
    p = (B7/B4)<<1;
    }
    
  X1 = (p>>8) * (p>>8);
  X1 = (X1 * 3038)>>16;
  X2 = (-7357 * p)>>16;
  p += (X1 + X2 + 3791)>>4;
  
  return p;
}
