//*****************************************
// メイン基板のサンプルプログラム
//*****************************************

#include "mbed.h"

//デジタル読み取りピンの指定
DigitalInOut Abutton(dp10);
DigitalInOut Bbutton(dp14);

//デジタル出力ピン(空気圧シリンダー)の指定
DigitalOut valve(dp11);

//アナログ読み取りピンの指定
AnalogIn JOYstick_LR(dp13);

//PWM出力ピン（モーター）の指定
PwmOut motorLRplus(dp1);
PwmOut motorLRminus(dp2);

//シリアル入出力ピンの指定
Serial Controller(dp16, dp15);

int main(void){
    
    //初期設定
    valve = 0;
    motorLRplus = 0.5;
    motorLRminus = 0.5;
    
    //出力レートの指定
    Controller.baud(9600);
    
    //デジタル入出力ピンの動作設定
    Abutton.input();
    Bbutton.input();

    int l=0;
    //なにかPCでシリアルを送るまでは動作しない
    while(1){       
        wait(0.5);
        if(Controller.readable()){
            break;
        }
        l ^= 1;
    }
    
    Controller.printf("LR  UD\n");

    int toggle = 0;    
    float tmp = 0.5;  
    while(1){
        
        //ジョイスティックの左右方向を読み取ってモータに投げる
        tmp = JOYstick_LR.read();
        Controller.printf("%f\n",tmp);
        motorLRplus = tmp;
        motorLRminus = 1-tmp;
        
        //タクトスイッチ(Aボタン)が押されていれば"A"を表示.シリンダをONに
        if(Abutton == 1 && Bbutton == 0 && toggle == 0){
            Controller.printf("A \n");
            valve = 1;
            toggle = 1;
            wait(0.05);
        }   
        //タクトスイッチ(Bボタン)が押されていれば"B"を表示.シリンダをOFFに
        else if(Abutton == 0 && Bbutton == 1 && toggle == 1){
            Controller.printf("B \n");
            valve = 0;
            toggle = 0;
            wait(0.05);
        }

        wait(0.05);
        
    }
    
}