//*******************************************
// 割り込みのサンプルプログラム
//*******************************************

//ヘッダファイル（もしくはライブラリ）をインクルード
#include "mbed.h"
#include "main.h"

//デジタル出力ピン(LED)の指定
DigitalOut Interrupt_LED1(dp9);
DigitalOut Interrupt_LED2(dp10);
DigitalOut Interrupt_LED3(dp11);
DigitalOut myLED(LED1);

//指定時間後に、一度だけ割り込みがかかる
Timeout Switch1;

//一定時間ごとに、繰り返し割り込みがかかる
Ticker Switch2;

int main(void){
    
    //初期設定（すべてのLEDを消灯しておく）
    Interrupt_LED1 = LOW;
    Interrupt_LED2 = LOW;
    Interrupt_LED3 = LOW;
    myLED = LOW;
    
    //指定時間（2秒後）に、一度だけ割り込みがかかる
    Switch1.attach(&LightGlowing, 2);
    
    //指定時間（10秒毎）に、繰り返し割り込みがかかる
    Switch2.attach(&LightFlash, 10);
    
    while(1){
        //メインLEDをチカチカさせる。割り込み動作中は止まる。
        myLED = HIGH;
        wait(0.5);
        myLED = LOW;
        wait(0.5);
    }
}

//３連LEDを順に点灯させる。プロトタイプ宣言はヘッダファイル内で行う
void LightGlowing(){
    wait(0.01);
    
    //LEDを順に光らせる
    Interrupt_LED1 = HIGH;
    wait(0.01);
    Interrupt_LED2 = LOW;
    wait(0.01);
    Interrupt_LED3 = LOW;
    
    wait(0.5);
    
    Interrupt_LED1 = HIGH;
    wait(0.01);
    Interrupt_LED2 = HIGH;
    wait(0.01);
    Interrupt_LED3 = LOW;
    
    wait(0.5);
    
    Interrupt_LED1 = HIGH;
    wait(0.01);
    Interrupt_LED2 = HIGH;
    wait(0.01);
    Interrupt_LED3 = HIGH;
    
    wait(0.5);
    
    Interrupt_LED1 = LOW;
    wait(0.01);
    Interrupt_LED2 = LOW;
    wait(0.01);
    Interrupt_LED3 = LOW;
    
}

//３連LEDを点滅させる。プロトタイプ宣言はヘッダファイル内で行う。
void LightFlash(){
    
    wait(0.01);
    
    //LEDを順に光らせる
    Interrupt_LED1 = HIGH;
    wait(0.01);
    Interrupt_LED2 = LOW;
    wait(0.01);
    Interrupt_LED3 = LOW;
    
    wait(0.5);
    
    Interrupt_LED1 = LOW;
    wait(0.01);
    Interrupt_LED2 = HIGH;
    wait(0.01);
    Interrupt_LED3 = LOW;
    
    wait(0.5);
    
    Interrupt_LED1 = LOW;
    wait(0.01);
    Interrupt_LED2 = LOW;
    wait(0.01);
    Interrupt_LED3 = HIGH;
    
    wait(0.5);
    
    Interrupt_LED1 = LOW;
    wait(0.01);
    Interrupt_LED2 = LOW;
    wait(0.01);
    Interrupt_LED3 = LOW;
    
}