//*******************************************
// 割り込みのサンプルプログラム
//*******************************************

//ヘッダファイル（もしくはライブラリ）をインクルード
#include "mbed.h"
#include "main.h"

//デジタル出力ピン(LED)の指定
DigitalOut Interrupt_LED1(dp9);
DigitalOut Interrupt_LED2(dp10);
DigitalOut Interrupt_LED3(dp11);
DigitalOut myLED(LED1);

//割り込み用ピンの指定(自動的に入力用に指定される)
InterruptIn TactSwitch(dp26);

int main(void){
    
    //初期設定（すべてのLEDを消灯しておく）
    Interrupt_LED1 = LOW;
    Interrupt_LED2 = LOW;
    Interrupt_LED3 = LOW;
    myLED = LOW;
    
    //立ち上がり割り込み(dp26がHIGHならここを割り込みで実行)
    TactSwitch.rise(&LightFlash);
    
    while(1){
        //メインLEDをチカチカさせる。割り込み動作中は止まる。
        myLED = HIGH;
        wait(0.5);
        myLED = LOW;
        wait(0.5);
    }
}

//３連LEDを光らせる関数。プロトタイプ宣言はヘッダファイル内で行う。
void LightFlash(){
    
    wait(0.01);
    
    //LEDを順に光らせる
    Interrupt_LED1 = HIGH;
    wait(0.01);
    Interrupt_LED2 = LOW;
    wait(0.01);
    Interrupt_LED3 = LOW;
    
    wait(0.5);
    
    Interrupt_LED1 = LOW;
    wait(0.01);
    Interrupt_LED2 = HIGH;
    wait(0.01);
    Interrupt_LED3 = LOW;
    
    wait(0.5);
    
    Interrupt_LED1 = LOW;
    wait(0.01);
    Interrupt_LED2 = LOW;
    wait(0.01);
    Interrupt_LED3 = HIGH;
    
    wait(0.5);
    
    Interrupt_LED1 = LOW;
    wait(0.01);
    Interrupt_LED2 = LOW;
    wait(0.01);
    Interrupt_LED3 = LOW;
    
}