//*****************************************
// コントローラのサンプルプログラム
//*****************************************

#include "mbed.h"

//デジタル読み取りピンの指定
DigitalInOut Abutton(dp25);
DigitalInOut Bbutton(dp26);

//デジタル出力ピン(モーター)の指定
DigitalInOut motorA(dp4);
DigitalInOut motorB(dp6);

//デジタル出力ピン(LED)の指定
DigitalInOut myLED(LED1);

//アナログ読み取りピンの指定
AnalogIn JOYstick_LR(dp9);
AnalogIn JOYstick_UD(dp10);

//PWM出力ピン（モーター？）の指定
PwmOut motorUDplus(dp1);
PwmOut motorUDminus(dp2);

//シリアル入出力ピンの指定
Serial Controller(dp16, dp15);

int main(void){
    
    //初期設定
    myLED = 0;
    motorA = 0;
    motorB = 0;
    motorUDplus = 0.5;
    motorUDminus = 0.5;
    
    //出力レートの指定
    Controller.baud(9600);
    
    //デジタル入出力ピンの動作設定
    Abutton.input();
    Bbutton.input();
    motorA.output();
    motorB.output();

    int l=0;
    while(1){       
        wait(0.5);
        if(Controller.readable()){
            break;
        }
        l ^= 1;
        myLED = l;
    }
    
    Controller.printf("LR  UD\n");
    
    float tmp;  
    while(1){
        
        //ジョイスティックの左右方向読み取り
        tmp = JOYstick_LR.read();
        Controller.printf("%f  ",tmp);

        //ジョイスティックの上下方向読み取り
        tmp = JOYstick_UD.read();
        Controller.printf("%f\n",tmp);
        motorUDplus = tmp;
        motorUDminus = 1-tmp;
        
        //タクトスイッチの動作全般
        
        //タクトスイッチ(Aボタン)が押されていれば"A"を表示.モータ正回転
        if(Abutton == 1 && Bbutton == 0){
            Controller.printf("A \n");
            motorA = 1;
            motorB = 0;
        }   
        //タクトスイッチ(Bボタン)が押されていれば"B"を表示.モータ逆回転
        else if(Abutton == 0 && Bbutton == 1){
            Controller.printf("B \n");
            motorA = 0;
            motorB = 1;
        }
        //タクトスイッチ(AボタンとBボタン)が押されていれば"AとB"を表示.モータは動かない
        else if(Abutton == 1 && Bbutton == 1){
            Controller.printf("A and B \n");
            motorA = 0;
            motorB = 0;
        }
        //何も押されていなければ、何も表示しない.モータは動かない
        else{
            motorA = 0;
            motorB = 0;
        }
        
    }
    
}