#ifndef Ka_FILE
#define Ka_FILE
#include "mbed.h"

/** My led class.
 *  Used for manipulating led light on the EFM32 Happy Gecko
 *
 * Example: Setting the led ON
 * @code
 * #include "mbed.h"
 * #include "Ka.h"
 * 
 * int main() {
 *     Ka obj; 
 *     obj.set_led0();
 * }
 * @endcode
 */
class Ka{    
    public : 
    /**  Constructor binds a object made from the Ka class to digitalout from mbed library
    */ 
    Ka();  
    /** Function for setting led0 to "on" */
    void set_led0();  
    /** Function for setting led0 to "off" */
    void clear_led0();  
    /** Function for inverting led0 (on to off, off to on) */ 
    void invert();  
    /** Function for making led0 blink. Takes amount of blink seconds as parameter*/
    void blinker (int a);  
    
    private:
    DigitalOut m;
    

};

#endif