#include "mbed.h"
#include <limits>

AnalogIn in(PA_0);
AnalogOut out(PA_4);

template<typename T>
bool in_range(const T& value, const T& max, const T& min)
{
    return min <= value && value <= max;
}

void startup()
{
    printf("Myszka test firmware booting up .....\n");
    for (int i = 0; i < 4; ++i) {
        printf(".\n");
        wait_ms(100);
    }
    printf("   DONE!\n");
}

int main() {
    while (1) {
        printf("Enter command in the format '<float> <float> <float>'\n");
        printf("okres_probkowania dac_value threshold\n");
        printf("\n");
        float okres_probkowania, dac_value, threshold;
        if (scanf("%f%f%f\n", &okres_probkowania, &dac_value, &threshold) != 3) {
            printf("Error in the input...\n");
            continue;
        }
        if (!in_range(okres_probkowania, 1.0f, 1000.0f)) {
            printf("Error - okres_probkowania musi byc w zakresie od 1 do 1000 milisekund.\n");
            continue;
        }
        if (!in_range(dac_value, 0.0f, 100.0f)) {
            printf("Error - dac_value musi byc w zakresie od 0 do 100 procent.\n");
            continue;
        }
        if (!in_range(threshold, 0.0f, 100.0f)) {
            printf("Error - threshold musi byc w zakresie of 0 do 100 procent.\n");
            continue;
        }
        
        out.write(dac_value / 100.0f);
        
        for (int i = 0;; ++i) {
            const float value = in.read();
            printf("%d %f\n", i, value);
            if (value > threshold) {
                printf("Value wieksze od threshold - breaking!\n");
                break;
            }
            if (i == std::numeric_limits<uint16_t>::max()) {
                printf("Za duzo probek - beraking!\n");
                break;
            }
        }
    }
}

