#include "SteeringServo.h"

// -- Constructor Function, Need to Initilise PWM Object
SteeringServo::SteeringServo(PinName pin, int centrePW, int minPW, int maxPW) : servo_(pin)
    {
    servo_.period_us(20000);            // -- Set PWM time period (20 ms)
    servo_.pulsewidth_us(centrePW);     // -- Default Set Steering to Straight Position
    minimumPulseWidth_ = minPW;
    maximumPulseWidth_ = maxPW;
    centrePulseWidth_ = centrePW;
    }

// -- Go to position
void SteeringServo::goToAngle(int pulseWidth)
{
    // -- Ensure that pulse width doesn't exceed limits
    if (pulseWidth < minimumPulseWidth_)
    {
        pulseWidth = minimumPulseWidth_;
    }
    else if (pulseWidth > maximumPulseWidth_)
    {
        pulseWidth = maximumPulseWidth_;
    }
    
    servo_.pulsewidth_us(currentPulseWidth_ = pulseWidth); // -- set servo to pulse width and also store it in currentPulseWidth
}

// -- Go to centre (generally used for debugging)
void SteeringServo::goStraight(void)
{
    servo_.pulsewidth_us(currentPulseWidth_ = centrePulseWidth_);
}
    
//-- return the current Pulse Width
int SteeringServo::getPulseWidth(void)
{
    return(currentPulseWidth_);
}
    