//Library for physics of LCD ball bouncing controlled by accelerometer
//Based on MMA8452Q and 4DGL-uLCD-SE library. 

#include "mbed.h"
#include "MMA8452Q.h"

#define DEFAULT_WIDTH 128
#define DEFAULT_HEIGHT 128
#define DEFAULT_SPEEDX 7
#define DEFAULT_SPEEDY 7
#define DEFAULT_POSX 64
#define DEFAULT_POSY 64
#define DEFAULT_RADIUS 10

// Class declaration
class physics_ball
{
    public:
        physics_ball(); //Constructor 
        float speedx;   //Returns ball speed in X direction 
        float speedy;   //Returns ball speed in Y direction 
        
        int posx;       //Returns ball location in X
        int posy;       //Returns ball location in Y
        
        int old_posx;   //Saves old posx
        int old_posy;   //Saves old posy
        
        int color;      //Assigns ball color 
        int radius;     //Assigns ball radius
        
        int width;      //Screen Spec: 128 pixel width
        int height;     //Screen Spec: 128 pixel Height 
         
        void update(MMA8452Q & accel); 
        // Calculates new ball position given time elapsed since last position
        
        void define_space(int width, int height); 
        // Defines environment, i.e the width & height of the area in which the ball can travel.
                                          
        void set_param(int radius, int color);    // Defines ball parameters: radius, color (1 or 2)
        
        void set_state(float x, float y, float speedx, float speedy); //Sets new ball position & speed
        
    private:

        float posx_f;
        float posy_f;
        
        };