#include "physics_ball.h"

//Constructor
physics_ball::physics_ball(){
    
    speedx = DEFAULT_SPEEDX;
    speedy = DEFAULT_SPEEDY;
    posx   = DEFAULT_POSX;
    posy   = DEFAULT_POSY;
    radius = DEFAULT_RADIUS;
    width  = DEFAULT_WIDTH;
    height = DEFAULT_HEIGHT;
    posy_f = (float) posx;
    posx_f = (float) posy;
    }
    
void physics_ball::set_param(int radius_in, int color_in)
 {
    radius = radius_in; 
    color = color_in;
    }   

void physics_ball::define_space( int width_in, int height_in)
{
    width = width_in;
    height = height_in;
    }

void physics_ball::set_state(float x_in, float y_in, float speedx_in, float speedy_in)
{
    posx_f = x_in;
    posy_f = y_in;
    
    speedx = speedx_in;
    speedy = speedy_in;
    }
    
void physics_ball::update(MMA8452Q & accel)
{
        posx_f = posx_f - (speedx * accel.readY());
        posy_f = posy_f - (speedy * accel.readX());
        
        posx = (int) posx_f;
        posy = (int) posy_f;
        
        
        //Ball  Physics 
        if ((posx <= radius) || (posx >= 128-radius)){
            speedx = -1 * speedx;
                 }
        if ((radius < posx) && (posx < 128- radius)){
             speedx = speedx;
             }
             
        if ((posy <= radius) || (posy >= 128-radius)) {
            speedy = -1 * speedy;
            
        if ((radius < posy) && (posy < 128- radius)){
             speedy = speedy;
             }
        }       
        
        old_posx = posx;
        old_posy = posy;
        
         // Reset when sensor is flipped upside down (For Ball 1 & 2)
        if (accel.readZ() < 0){
            set_state(DEFAULT_POSX, DEFAULT_POSY, 5, 5);
        }
         }
        
         
              
              
              