//Kaitlyn Barros
//OCE 360 Fall 2017 

//Last Revised: Nov 16 2017 

//Software Exercise 4:
//1. Update the software system by creating a new library, which includes 
//   a class that defines the behavior of a bouncing ball on the LCD screen.
//2. Demonstrate the system with two or more bouncing balls on the screen.
//3. Show that the system resets the ball locations when you hold the 
//   accelerometer upside down. 

//Software Exercise 5:
//1. Update the ball postion using the accelerometer's data at 50Hz. Update the LCD display w/ ball postions at 11HZ. 
//2. Use a buttom interrupt to turn data recording on/off. Use an onboard LED to indicate recording.

//Software Exercise 6:
//Install a button to freeze the balls for 2 seconds when pressed. 
//Configure a freefall into the accel that freezes the balls when sensed.  

#include "mbed.h"          //Mbed Header
#include "physics_ball.h"  // Physics Ball Behavior Header
#include "uLCD_4DGL.h"     // LCD Header
#include "MMA8452Q.h"      // Accelerometer Header

Serial pc(USBTX, USBRX);               // USB Serial (tx, rx)

DigitalOut led1(LED1);                 //Onboard LED 1
DigitalOut led2(LED2);                 //Onboard LED 2


DigitalIn  switchinput(p18);            //Digital switch set in Pin 18
DigitalIn  AccelInter(p17);            //Digital switch caused by accelerometer INT1 pin

// Call out classes (For Ball 1 & 2)
physics_ball ball1;
physics_ball ball2; 
    
// Graphic LCD - TX, RX, and RES pins
uLCD_4DGL uLCD(p9,p10,p11);

// Accelerometer - SDA, SCL, and I2C address
MMA8452Q accel(p28, p27, 0x1D);

// Call out Tickers 
Ticker BallUpdate;
Ticker LCDUpdate;

//Ticker Function 1: Ball_Update_Pos
void BUP(){
    //Update Ball Postion
     ball1.update(accel);
     ball2.update(accel);
    }

//Ticker Function 2: LCD_Update_Pos
void LCDUP(){
     if (switchinput == 0 || AccelInter == 1){
     // Draw new circle 
        uLCD.filled_circle(ball1.posx, ball1.posy, ball1.radius, BLUE); 
        uLCD.filled_circle(ball2.posx, ball2.posy, ball2.radius, RED); 
        led1 = 1;
    // Erase old circle (For Ball 1 & 2)
        uLCD.filled_circle(ball1.old_posx, ball1.old_posy, ball1.radius, BLACK);
        uLCD.filled_circle(ball2.old_posx, ball2.old_posy, ball2.radius, BLACK);
        led1= 0;
        }
    else if (switchinput ==1 || AccelInter == 0){
        // Draw new circle 
        uLCD.filled_circle(ball1.posx, ball1.posy, ball1.radius, BLUE); 
        uLCD.filled_circle(ball2.posx, ball2.posy, ball2.radius, RED); 
        led1 = 1;
        wait(2);
        // Erase old circle (For Ball 1 & 2)
        uLCD.filled_circle(ball1.old_posx, ball1.old_posy, ball1.radius, BLACK);
        uLCD.filled_circle(ball2.old_posx, ball2.old_posy, ball2.radius, BLACK);
        led1= 0;
        }
            }

int main() {
    // Initialize uLCD
    uLCD.baudrate(115200);
    uLCD.background_color(BLACK);
    uLCD.cls();

    // Initialize accelerometer
    accel.init();
     
    //Intial Ball Conditions & Reset Conditiosn
    ball1.define_space(ball1.width, ball1.height);
    ball2.define_space(ball2.width, ball2.height);
    
    ball1.set_param(ball1.radius, BLUE);
    ball2.set_param(ball2.radius, RED);    
    
    //Tickers
    BallUpdate.attach(&BUP, 0.02); //50 Hz
    LCDUpdate.attach(&LCDUP, 0.09);//11 Hz 
 
 while (1) { }
 }