//main.cpp
/****************************************************************
* Include files
****************************************************************/
#include "header.h"

/****************************************************************
* data values
****************************************************************/
#define cal -200   // calibration value

int A2D_in;      /* input variable */
int V_in;        /* input voltage */
int V_unit;      /* voltage units value */
int V_unit_old;  // previous unit value
int V_in_dec;    /* input voltage decimal value */
int V_dec;       /* voltage decimal value */
int V_dec_old;   // previous decimal value
float x;

/****************************************************************
* Main part of the program
****************************************************************/
int main()
{
  
  ADC_init();
  LCD_init();
  LCD_displayV();
  
while(1){				/*  infinite loop */
 
    A2D_in=ADC_read();
    V_in=A2D_in*33;       /* calculate voltage from 8-bit ADC input 0xFF = 3.3V */
                          // all voltage values multiplied by 10 to allow integer manipulation
      
      
      //****************** calculate voltage unit = 0-5V ******************************
      if(V_in >= 50*255)        // if greater than 5V then unit to display = 5  
      {
        V_unit = 0x05;
        V_in_dec  = 0;          // if unit = 5 then decimal must be 0 (5.0V=max) 
      } 
      else if(V_in > 40*255)    // else if greater than 4V then unit to display = 4 
      {
        V_unit = 0x04;
        V_in_dec  = V_in-40*256;  // calculate remainder for decimal processing
      }
      else if(V_in > 30*255)     // else if greater than 3V then unit to display = 3
      {
        V_unit = 0x03;
        V_in_dec  = V_in-30*256;
      }      
      else if(V_in > 20*255)     // else if greater than 2V then unit to display = 2
      { 
        V_unit = 0x02;
        V_in_dec  = V_in-20*256;
      } 
      else if(V_in > 10*255)     // else if greater than 1V then unit to display = 1
      {
        V_unit = 0x01;
        V_in_dec  = V_in-10*256;
      } 
      else	                     // else unit to display = 0
      {
        V_unit = 0x00;
        V_in_dec  = V_in;
      }
      
      // if unit has changed, then display the new unit on the screen
      if (V_unit!= V_unit_old){
        
       //  start of line 2  
      FIO2CLR0=0x02;		 /* set RS to 'instruction' */
      FIO0PIN2=0xC6;		 /* set address to line 2 units position*/
      toggle_enable();
	  FIO2SET0=0x02;		 /* set RS to 'data' */
	      
      FIO0PIN2=(0x30+V_unit);    // display unit value on screen		       
      toggle_enable();
      V_unit_old=V_unit;
      }
      
      
      //****************** calculate decimal value = .0 - .9 ******************************
      if(V_in_dec <=260+cal)	
       V_dec = 0x00;
      if(V_in_dec > 260+cal)       // decimal value must be between 0 and 2550 (ie 255*10)
       V_dec = 0x01;
      if(V_in_dec > 510+cal)       // calibration value allows an amount of simple tuning
       V_dec = 0x02;               // any error should be linear, but maybe with an offset
      if(V_in_dec > 770+cal)       // a complete look-up table would be better though!
       V_dec = 0x03;
      if(V_in_dec > 1120+cal)
       V_dec = 0x04;
      if(V_in_dec > 1280+cal)
       V_dec = 0x05;
      if(V_in_dec > 1530+cal)
       V_dec = 0x06;
      if(V_in_dec > 1780+cal)
       V_dec = 0x07;
      if(V_in_dec > 2040+cal)
       V_dec = 0x08;
      if(V_in_dec > 2300+cal)
       V_dec = 0x09; 
       
      // if decimal value has changed then update display
      if (V_dec!= V_dec_old){
        
        // start of line 2  */
       	FIO2CLR0=0x02;		 /* set RS to 'instruction' */
       	FIO0PIN2=0xC8;		       /* set address to line 2 */
       	toggle_enable();
		FIO2SET0=0x02;		 /* set RS to 'data' */
		
        FIO0PIN2=(0x30+V_dec);		       
        toggle_enable();
        V_dec_old=V_dec;
      }
  }
  
} /* end main() */