// ADC_setup.cpp

#include "header.h"
/*****************************************************
 variables and defines
 ****************************************************/

int ADC_channel=1;     // ADC channel 1

/*****************************************************
  subroutines
*****************************************************/
void ADC_init(){

     PINSEL1=0x00010000;  //set AD0.1 pin to 0000 0000 0000 0001 0000 0000 0000 0000 = ADC
     PCONP |= (1 << 12);  // enable ADC clock 
     AD0CR = (1 << ADC_channel)     // channel 1 
           | (4 << 8)     // This gives us 3MHz 
           | (0 << 16)    // BURST = 0, software control  
           | (0 << 17)    // CLKS = 0 (11-bits)  
           | (1 << 21)    // PDN = 1  
           | (0 << 22)    // TEST1:0 = 00  
           | (1 << 24)    // START = 1 start A/D conversion 
           | (0 << 27);   // EDGE = 0 (CAP/MAT singal falling,trigger A/D conversion) 
}
float ADC_read() { 

    int data;
     
    // start A/D conversion on channel 
    AD0CR &= (AD0CR & 0xFFFFFF00);  
    AD0CR |= (1 << ADC_channel) | (1 << 24);       
  
    delay_l();
  
    // wait for it to finish by polling the ADC DONE bit         
    while((AD0GDR & 0x80000000) == 0) 
    {
    }
      
    // get the data and stop the adc 
    data = AD0GDR; 
    AD0CR &= 0xF8FFFFFF; 
  
    // shift data and mask to give 8-bit ADC value
    data=(data>>8)&0x00000FF;  
    return data; 
 } 