/* header.h header file */

/*******************************************************/
/* function prototypes */
/*******************************************************/
                                                                                       
/* main.cpp prototypes */
 
/* ADC_setup.cpp prototypes */
void ADC_init(void); 
float ADC_read(void);
 
/* LDC_setup.cpp prototypes */                                                         
void LCD_init(void);
void LCD_displayV(void);
void toggle_enable(void);

/* mbed_functions.cpp prototypes*/
void delay_s(void);
void delay_l(void);

/********************************************************/
/* #defines                                              */
/********************************************************/

// *** mc9s12dp256 register addresses

 // Pin Assignment 
 #define PINSEL_BASE_ADDR        0xE002C000 
 //PINSEL1
 #define PINSEL1        (*(volatile unsigned long *)(PINSEL_BASE_ADDR + 0x04))
 
 //SCS - System Controls and Status, & Power Control */ 
 #define SCB_BASE_ADDR   0xE01FC000
 #define SCS            (*(volatile unsigned long *)(SCB_BASE_ADDR + 0x1A0))   
 #define PCONP          (*(volatile unsigned long *)(SCB_BASE_ADDR + 0x0C4)) 
 
 // Digital IO registers
 #define FIO_BASE_ADDR           0x3FFFC000
 //FIO2DIR0
 #define FIO2DIR0       (*(volatile unsigned char *)(FIO_BASE_ADDR + 0x40)) 
 //FIO2PIN0
 #define FIO2PIN0       (*(volatile unsigned char *)(FIO_BASE_ADDR + 0x54)) 
 //FIO2CLR0
 #define FIO2CLR0       (*(volatile unsigned char *)(FIO_BASE_ADDR + 0x5C))
 //FIO2SET0
 #define FIO2SET0       (*(volatile unsigned char *)(FIO_BASE_ADDR + 0x58)) 
 //FIO0DIR2
 #define FIO0DIR2       (*(volatile unsigned char *)(FIO_BASE_ADDR + 0x02))
 //FIO0PIN2
 #define FIO0PIN2       (*(volatile unsigned char *)(FIO_BASE_ADDR + 0x16))

 // ADC registers
 #define AD0_BASE_ADDR           0xE0034000
 //AD0CR
 #define AD0CR          (*(volatile unsigned long *)(AD0_BASE_ADDR + 0x00)) 
 //AD0GDR
 #define AD0GDR         (*(volatile unsigned long *)(AD0_BASE_ADDR + 0x04)) 


/* LCD display constants */
#define _sp 0x20 /* space */
#define _eq 0x3d /* = sign */
#define _0 0x30
#define _1 0x31
#define _2 0x32
#define _3 0x33
#define _4 0x34
#define _5 0x35
#define _6 0x36
#define _7 0x37
#define _8 0x38
#define _9 0x39
#define _A 0x41
#define _B 0x42
#define _C 0x43
#define _D 0x44
#define _E 0x45
#define _F 0x46
#define _G 0x47
#define _H 0x48
#define _I 0x49
#define _J 0x4a
#define _K 0x4b
#define _L 0x4c
#define _M 0x4d
#define _N 0x4e
#define _O 0x4f
#define _P 0x50
#define _Q 0x51
#define _R 0x52
#define _S 0x53
#define _T 0x54
#define _U 0x55
#define _V 0x56
#define _W 0x57
#define _X 0x58
#define _Y 0x59
#define _Z 0x5a
#define _a 0x61
#define _b 0x62
#define _c 0x63
#define _d 0x64
#define _e 0x65
#define _f 0x66
#define _g 0x67
#define _h 0x68
#define _i 0x69
#define _j 0x6a
#define _k 0x6b
#define _l 0x6c
#define _m 0x6d
#define _n 0x6e
#define _o 0x6f
#define _p 0x70
#define _q 0x71
#define _r 0x72
#define _s 0x73
#define _t 0x74
#define _u 0x75
#define _v 0x76
#define _w 0x77
#define _x 0x78
#define _y 0x79
#define _z 0x7a