// LCD_setup.cpp

#include "header.h"
/*****************************************************
  subroutines
*****************************************************/
/****initialise LCD function ****/  
void LCD_init(void){  
	delay_l();
    FIO2DIR0=0xFF;  /* set port 2 byte 0 (ctrl) to output */
    FIO2PIN0=0x00;   //clear Port 2 byte 0 
		                 //FIO2PIN bit0=R/W	 (read/write)
              		     //FIO2PIN bit1=RS	 (register select)
                		 //FIO2PIN bit2=E    (enable)
						 //all initialised low
                 
	        		     // set Port 0 and 1 to operate as fast registers			
    SCS |= 0x00000001;  //  by setting the GPIOM bit of the SCS register
    FIO0DIR2=0xFF;       // set port 0 byte 2 (data) to output 
    FIO0PIN2=0x00;		 // clear Port 0 byte 2  
 
  /* RS already initialised to 'instruction' (low) */
	
	/**** Function set*/
  FIO0PIN2=0x38;		      /* 2-line mode, 7 dot characters */					
  toggle_enable();
 
  /**** Display on/off*/
  FIO0PIN2=0x0C;		      /* display on, cursor off, blink off */					
  toggle_enable();
 	 	
  /**** Clear display */
  FIO0PIN2=0x01;		      /* clear */
  toggle_enable();
  
  /**** Set entry mode */				
  FIO0PIN2=0x06;       	 /* increment cursor, shift off */
  toggle_enable();
     
}


/**** LCD Display 'Voltmeter' */
void LCD_displayV(){
  FIO2CLR0=0x02;		 /* set RS to 'control' */
  FIO0PIN2=0x01;		      /* clear display*/
  toggle_enable();						
  FIO2SET0=0x02;		 /* set RS to 'data' */					
  
    FIO0PIN2=_sp;       // process and display character		      
  toggle_enable();
    FIO0PIN2=_sp;		      
  toggle_enable();
    FIO0PIN2=_sp;		      
  toggle_enable();    
    FIO0PIN2=_V;		       
  toggle_enable();  
    FIO0PIN2=_O;		       
  toggle_enable();
    FIO0PIN2=_L;		       
  toggle_enable();
    FIO0PIN2=_T;		       
  toggle_enable();
    FIO0PIN2=_M;		       
  toggle_enable();
    FIO0PIN2=_E;		       
  toggle_enable();  
    FIO0PIN2=_T;		       
  toggle_enable();
    FIO0PIN2=_E;		       
  toggle_enable();  
    FIO0PIN2=_R;		       
  toggle_enable();
  
  /* start of line 2  */
  FIO2CLR0=0x02;		 /* set RS to 'instruction' */
  FIO0PIN2=0xC6;		       /* set address to line 2 */
  toggle_enable();
  FIO2SET0=0x02;		 /* set RS to 'data' */
      
  FIO0PIN2=_0;		       
  toggle_enable();  
  FIO0PIN2=0x2e;		       
  toggle_enable();
  FIO0PIN2=_0;		       
  toggle_enable();
  FIO0PIN2=_V;		       
  toggle_enable();
}

/*** toggle_enable */
void toggle_enable(void){
 	FIO2SET0=0x04;		 // Toggle enable flag on */
 	delay_s();			
 	FIO2CLR0=0x04;		 /* Toggle enable flag off */
 	delay_s();
}

/**************************************************************************
* DEM16217 LCD connected to mbed as follows:
**************************************************************************
RW  = Read/Write     = LCD pin05 = mbed pin16  = LPC pin75 = GPIO P2.0 (Port2,byte0,bit0)
RS  = RegisterSelect = LCD pin04 = mbed pin15  = LPC pin74 = GPIO P2.1 (0,1)
E   = Enable         = LCD pin06 = mbed pin14  = LPC pin73 = GPIO P2.2 (0,2)
DB0 = Data Bit 0     = LCD pin07 = mbed pin10  = LPC pin63 = GPIO P0.16 (Port0,byte2,bit0)
DB1 = Data Bit 1     = LCD pin08 = mbed pin08  = LPC pin61 = GPIO P0.17 (2,1)
DB2 = Data Bit 2     = LCD pin09 = mbed pin07  = LPC pin60 = GPIO P0.18 (2,2)
DB3 = Data Bit 3     = LCD pin10 = mbed pin06  = LPC pin59 = GPIO P0.19 (2,3)
DB4 = Data Bit 4     = LCD pin11 = mbed pin05  = LPC pin58 = GPIO P0.20 (2,4)   
DB5 = Data Bit 5     = LCD pin12 = mbed pin04  = LPC pin57 = GPIO P0.21 (2,5) 
DB6 = Data Bit 6     = LCD pin13 = mbed pin03  = LPC pin56 = GPIO P0.22 (2,6)
DB7 = Data Bit 7     = LCD pin14 = mbed pin36  = LPC pin09 = GPIO P0.23 (2,7)
**************************************************************************/