#include "mbed.h"

#define   BLACK            0x0000
#define   NAVY            0x000F
#define   DARK_GREEN    0x03E0
#define   DARK_CYAN        0x03EF
#define   MAROON        0x7800
#define   PURPLE        0x780F
#define   OLIVE            0x7BE0
#define   LIGHT_GRAY    0xC618
#define   DARK_GRAY        0x7BEF
#define   BLUE            0x001F
#define   GREEN            0x07E0
#define   CYAN          0x07FF
#define   RED           0xF800
#define   MAGENTA        0xF81F
#define   YELLOW        0xFFE0
#define   WHITE            0xFFFF



SPI spi (5,6,7);
DigitalOut cs (13);
DigitalOut rst (17);
DigitalOut tcs (23);



int    _hwidth = 320;
int    _hheight = 240;

void command(int value);
void data(int value);
void config(int index, int value);
void lcd_movePen(int x, int y);
void lcd_fillScreen(int color);

void lcd_point(int x, int y, int color);
void lcd_circle(int x0, int y0, int r, int color);

int main() {

    spi.frequency(10000000);
    spi.format(9);


    cs = 0;

    rst = 0;
    wait(0.001);
    rst = 1;
    wait(0.001);



    config(0x07
           , 1 << 5 // GON
           | 0 << 4 // DTE
           | 0 << 3 // CM
           | 1 << 0 // D[1:0] = 01 - operate, but disp off
          );

    config(0x00, 0001);

    config(0x07, 1 << 5 | 1 << 4 | 0 << 3 | 3 << 0 );

    config(0x10, 0000);

    wait(0.030);

    config(0x02, 0x0600);
    config(0x01, 0x2b3f);  // 1011
    config(0x25, 0xa000);    // 70Hz freq





    while (1) {

        lcd_fillScreen(WHITE);

        lcd_fillScreen(BLUE);
        lcd_fillScreen(GREEN);

    }
}


void command(int value) {
    spi.write(value & 0xFF);
}

void data(int value) {
    spi.write(value | 0x100);
}

void config(int index, int value) {
    command(0);
    command(index);
    data(value >> 8);
    data(value);
}


void lcd_movePen(int x, int y) {
    config(0x4e, x & 0x00ff);
    config(0x4f, y & 0x01ff);
    command(0);
    command(0x22);
}

void lcd_fillScreen(int color) {
    int i = 0;
    int j = 0;

    lcd_movePen(0, 0);

    for (i=0; i < _hwidth; i++) {
        for (j=0; j< _hheight; j++) {
            data(color >> 8);
            data(color);
        }
    }
}
void lcd_point(int x, int y, int color) {
    data(color >> 8);
    data(color);

}

void lcd_circle(int x0, int y0, int r, int color) {
    int draw_x0, draw_y0;
    int draw_x1, draw_y1;
    int draw_x2, draw_y2;
    int draw_x3, draw_y3;
    int draw_x4, draw_y4;
    int draw_x5, draw_y5;
    int draw_x6, draw_y6;
    int draw_x7, draw_y7;
    int xx, yy;
    int di;


    draw_x0 = draw_x1 = x0;
    draw_y0 = draw_y1 = y0 + r;
    if (draw_y0 < _hheight) {
        lcd_point(draw_x0, draw_y0, color);        /* 90 degree */
    }

    draw_x2 = draw_x3 = x0;
    draw_y2 = draw_y3 = y0 - r;
    if (draw_y2 >= 0) {
        lcd_point(draw_x2, draw_y2, color);    /* 270 degree */
    }

    draw_x4 = draw_x6 = x0 + r;
    draw_y4 = draw_y6 = y0;
    if (draw_x4 < _hwidth) {
        lcd_point(draw_x4, draw_y4, color);        /* 0 degree */
    }

    draw_x5 = draw_x7 = x0 - r;
    draw_y5 = draw_y7 = y0;
    if (draw_x5>=0) {
        lcd_point(draw_x5, draw_y5, color);        /* 180 degree */
    }

    if (r == 1) {
        return;
    }

    di = 3 - 2*r;
    xx = 0;
    yy = r;
    while (xx < yy) {
        if (di < 0) {
            di += 4*xx + 6;
        } else {
            di += 4*(xx - yy) + 10;
            yy--;
            draw_y0--;
            draw_y1--;
            draw_y2++;
            draw_y3++;
            draw_x4--;
            draw_x5++;
            draw_x6--;
            draw_x7++;
        }
        xx++;
        draw_x0++;
        draw_x1--;
        draw_x2++;
        draw_x3--;
        draw_y4++;
        draw_y5++;
        draw_y6--;
        draw_y7--;

        if ( (draw_x0 <= _hwidth) && (draw_y0>=0) ) {
            lcd_point(draw_x0, draw_y0, color);
        }

        if ( (draw_x1 >= 0) && (draw_y1 >= 0) ) {
            lcd_point(draw_x1, draw_y1, color);
        }

        if ( (draw_x2 <= _hwidth) && (draw_y2 <= _hheight) ) {
            lcd_point(draw_x2, draw_y2, color);
        }

        if ( (draw_x3 >=0 ) && (draw_y3 <= _hheight) ) {
            lcd_point(draw_x3, draw_y3, color);
        }

        if ( (draw_x4 <= _hheight) && (draw_y4 >= 0) ) {
            lcd_point(draw_x4, draw_y4, color);
        }

        if ( (draw_x5 >= 0) && (draw_y5 >= 0) ) {
            lcd_point(draw_x5, draw_y5, color);
        }
        if ( (draw_x6 <= _hwidth) && (draw_y6 <= _hheight) ) {
            lcd_point(draw_x6, draw_y6, color);
        }
        if ( (draw_x7 >= 0) && (draw_y7 <= _hheight) ) {
            lcd_point(draw_x7, draw_y7, color);
        }
    }
}



