#include "mbed.h"
#include "const.h"
#include "Date.h"
    
    
uint8_t bcdToUint(uint8_t const nybbles)
{
    uint8_t result;
    result = (nybbles >>4)*10 + (nybbles & 0x0F);
    return result;
} 

uint8_t Date::GetDay()
{
    uint8_t day = rtc_read(DAYS);
    return bcdToUint(day & 0x3F);
}
uint8_t Date::GetMonth()
{
    uint8_t month = rtc_read(MONTHS);
    return bcdToUint(month & 0x07F);
}
uint8_t Date::GetYear()
{
    uint8_t year = rtc_read(YEARS);
    return bcdToUint(year & 0x3F);
}
uint8_t Date::GetWeek()
{
    uint8_t week = rtc_read(WEEKDAYS);
    return bcdToUint(week & 0x07);       
}