#include "MorseOut.h"

MorseOut::MorseOut(PinName Pin):DigitalOut(Pin)
{
    _Timer.attach(this,&MorseOut::_Update,0.1);
    _InputPos=_OutputPos=0;
}

char* MorseOut::getmorse(char value)
{
    char* Code="";
    switch(value){ //a = low, b = high
        case 'a': Code=". -  "; break;
        case 'b': Code="- . . .  "; break;
        case 'c': Code="- . - .  "; break;
        case 'd': Code="- . .  "; break;
        case 'e': Code=".  "; break;
        case 'f': Code=". . - .  "; break;
        case 'g': Code="- - .  "; break;
        case 'h': Code=". . . .  "; break;
        case 'i': Code=". .  "; break;
        case 'j': Code=". - - -  "; break;
        case 'k': Code="- . -  "; break;
        case 'l': Code=". - . .  "; break;
        case 'm': Code="- -  "; break;
        case 'n': Code="- .  "; break;
        case 'o': Code="- - -  "; break;
        case 'p': Code=". - - .  "; break;
        case 'q': Code="- - . -  "; break;
        case 'r': Code=". - .  "; break;
        case 's': Code=". . .  "; break;
        case 't': Code="-  "; break;
        case 'u': Code=". . -  "; break;
        case 'v': Code=". . . -  "; break;
        case 'w': Code=". - -  "; break;
        case 'x': Code="- . . -  "; break;
        case 'y': Code="- . - -  "; break;
        case 'z': Code="- - . .  "; break;
        
        case 'A': Code=". -  "; break;
        case 'B': Code="- . . .  "; break;
        case 'C': Code="- . - .  "; break;
        case 'D': Code="- . .  "; break;
        case 'E': Code=".  "; break;
        case 'F': Code=". . - .  "; break;
        case 'G': Code="- - .  "; break;
        case 'H': Code=". . . .  "; break;
        case 'I': Code=". .  "; break;
        case 'J': Code=". - - -  "; break;
        case 'K': Code="- . -  "; break;
        case 'L': Code=". - . .  "; break;
        case 'M': Code="- -  "; break;
        case 'N': Code="- .  "; break;
        case 'O': Code="- - -  "; break;
        case 'P': Code=". - - .  "; break;
        case 'Q': Code="- - . -  "; break;
        case 'R': Code=". - .  "; break;
        case 'S': Code=". . .  "; break;
        case 'T': Code="-  "; break;
        case 'U': Code=". . -  "; break;
        case 'V': Code=". . . -  "; break;
        case 'W': Code=". - -  "; break;
        case 'X': Code="- . . -  "; break;
        case 'Y': Code="- . - -  "; break;
        case 'Z': Code="- - . .  "; break;
        
        case '0': Code="- - - - -  "; break;
        case '1': Code=". - - - -  "; break;
        case '2': Code=". . - - -  "; break;
        case '3': Code=". . . - -  "; break;
        case '4': Code=". . . . -  "; break;
        case '5': Code=". . . . .  "; break;
        case '6': Code="- . . . .  "; break;
        case '7': Code="- - . . .  "; break;
        case '8': Code="- - - . .  "; break;
        case '9': Code="- - - - .  "; break;
        case ' ': Code="  "; break;
        default:
            return 0;
    }
    
    return Code;
}

void MorseOut::putc(char value)
{
//Get code
    char *Code="";
    switch(value){ //a = low, b = high
        case 'a': Code="babbba"; break;
        case 'b': Code="bbbabababa"; break;
        case 'c': Code="bbbababbbaba"; break;
        case 'd': Code="bbbababa"; break;
        case 'e': Code="ba"; break;
        case 'f': Code="bababbbaba"; break;
        case 'g': Code="bbbabbbaba"; break;
        case 'h': Code="babababa"; break;
        case 'i': Code="baba"; break;
        case 'j': Code="babbbabbbabbba"; break;
        case 'k': Code="bbbababbba"; break;
        case 'l': Code="babbbababa"; break;
        case 'm': Code="bbbabbba"; break;
        case 'n': Code="bbbaba"; break;
        case 'o': Code="bbbabbbabbba"; break;
        case 'p': Code="babbbabbbaba"; break;
        case 'q': Code="bbbabbbababbba"; break;
        case 'r': Code="babbbaba"; break;
        case 's': Code="bababa"; break;
        case 't': Code="bbba"; break;
        case 'u': Code="bababbba"; break;
        case 'v': Code="babababbba"; break;
        case 'w': Code="babbbabbba"; break;
        case 'x': Code="bbbabababbba"; break;
        case 'y': Code="bbbababbbabbba"; break;
        case 'z': Code="bbbabbbababa"; break;
        
        case 'A': Code="babbba"; break;
        case 'B': Code="bbbabababa"; break;
        case 'C': Code="bbbababbbaba"; break;
        case 'D': Code="bbbababa"; break;
        case 'E': Code="ba"; break;
        case 'F': Code="bababbbaba"; break;
        case 'G': Code="bbbabbbaba"; break;
        case 'H': Code="babababa"; break;
        case 'I': Code="baba"; break;
        case 'J': Code="babbbabbbabbba"; break;
        case 'K': Code="bbbababbba"; break;
        case 'L': Code="babbbababa"; break;
        case 'M': Code="bbbabbba"; break;
        case 'N': Code="bbbaba"; break;
        case 'O': Code="bbbabbbabbba"; break;
        case 'P': Code="babbbabbbaba"; break;
        case 'Q': Code="bbbabbbababbba"; break;
        case 'R': Code="babbbaba"; break;
        case 'S': Code="bababa"; break;
        case 'T': Code="bbba"; break;
        case 'U': Code="bababbba"; break;
        case 'V': Code="babababbba"; break;
        case 'W': Code="babbbabbba"; break;
        case 'X': Code="bbbabababbba"; break;
        case 'Y': Code="bbbababbbabbba"; break;
        case 'Z': Code="bbbabbbababa"; break;
        
        case '0': Code="bbbabbbabbbabbbabbba"; break;
        case '1': Code="babbbabbbabbbabbba"; break;
        case '2': Code="bababbbabbbabbba"; break;
        case '3': Code="babababbbabbba"; break;
        case '4': Code="bababababbba"; break;
        case '5': Code="bababababa"; break;
        case '6': Code="bbbababababa"; break;
        case '7': Code="bbbabbbabababa"; break;
        case '8': Code="bbbabbbabbbababa"; break;
        case '9': Code="bbbabbbabbbabbbaba"; break;
        case ' ': Code="aa"; break;
        default:
            return;
    
    }

//Insert code into buffer
    unsigned short i=0;
    while(Code[i]!=0){
        _Buffer[_InputPos]=Code[i]-'a';
        _InputPos++;
        if(_InputPos>=_BufferSize)
            _InputPos=0;
        i++;
    }
}

void MorseOut::puts(char* value)
{
//Loop through string and convert each character
    unsigned short i=0;
    while(value[i]!=0){
        putc(value[i]);
        i++;
    }
}

void MorseOut::_Update()
{
//Check if there is any new data in the buffer
    if(_InputPos!=_OutputPos){
    //Send next bit
        write(_Buffer[_OutputPos]);
        
    //Increase output pos
        _OutputPos++;
        if(_OutputPos>=_BufferSize)
            _OutputPos=0;
    }
}