#include "mbed.h"
#include "USBAudio.h"

#define FREQ                    48000
#define NUMBER_CHANNEL          2
#define LENGTH_AUDIO_PACKET     (FREQ / 500) * NUMBER_CHANNEL

// USB Audio object
USBAudio audio(FREQ, NUMBER_CHANNEL, FREQ, NUMBER_CHANNEL, 0xab45, 0x0378);

// Analog input objects
AnalogIn pot0(p17);
AnalogIn pot1(p18);

// Input and output buffers
int16_t buf_in[LENGTH_AUDIO_PACKET/sizeof(int16_t)][2];
int16_t buf_out[LENGTH_AUDIO_PACKET/sizeof(int16_t)][2];

int main()
{
    while (1)
    {
        // read and write one audio packet each frame
        audio.readWrite((uint8_t *)buf_in, (uint8_t *)buf_out);
        
        int16_t analog_input[2] = {pot0.read_u16() / 64, pot1.read_u16() / 64};

        for (int i = 0; i < LENGTH_AUDIO_PACKET/sizeof(int16_t); i++)
        {
            buf_out[i][0] = analog_input[0];
            buf_out[i][1] = analog_input[1];
        }
    }
}
