#include "stdio.h"
#include "mbed.h"
#include "ColorMemLCD.h"
//#include "SDFileSystem.h"

#include "string"
#include "Prototype24x27.h"
#include "Prototype_num21x25.h"
//#include "meirio_num11x14.h"

#include "bmp_caterpillar_4bit.h"
#include "bmp_leaf_4bit.h"
#include "bmp_watch_4bit.h"

#include "symb_block.h"
#include "symb_block_rev.h"

//SDFileSystem        sd( PTE3, PTE1, PTE2, PTE4, "sd" );          // mosi,miso,sck,cs
ColorMemLCD    LCD( PTD2, PTD3, PTD1, PTD0, PTC4, PTD3, "TFT" );   // mosi, miso, sclk, cs, reset, (power)
Ticker pollingTimer;

void pollingTimerHandler()
{
    LCD.polling();
}

int main()
{
    int i,j,k;
    int pic_height, window_height;
    int Divide = 8;                // separate for 8 windows to save memory
    int Block = LCD_DISP_HEIGHT / Divide; 

    pollingTimer.attach( &pollingTimerHandler, 1.0 );
    LCD.command_AllClear();
    
    /*  SD read  */
    //LCD.BMP_24(0,0,"/sd/sample.bmp");

    while(1) {
        
        /* Turn white - whole the screen */
        LCD.background( LCD_COLOR_WHITE );
        for(j = 0 ; j <Divide ; j++) {
            LCD.window(0, j*Block, LCD_DISP_WIDTH, Block);
            LCD.cls();
            LCD.update();
        }

        /* Hello */
        pic_height = 44;
        window_height = 44; 
        LCD.foreground( LCD_COLOR_GREEN );
        LCD.window( 0, 10, LCD_DISP_WIDTH, window_height);
        LCD.cls();
        LCD.Bitmap4bit(82, 10, 88, pic_height, (unsigned char *)bmp_caterpillar_4bit);
        LCD.locate(4, 10);
        LCD.set_font( (unsigned char*)Prototype24x27 );
        LCD.printf("Hello");
        LCD.update();
        wait(0.8);      

        /* world */  
        pic_height = 88;
        window_height = 44; 
        LCD.window(0, 132, LCD_DISP_WIDTH, pic_height);
        LCD.cls();
        LCD.locate(92, 148);
        LCD.set_font( (unsigned char*)Prototype24x27 );
        LCD.printf("world");
        LCD.update();
        for(j=0; j<pic_height/window_height; j++){
            LCD.window( 0, 60+j*window_height, LCD_DISP_WIDTH, window_height);
            LCD.Bitmap4bit( 0, 60, 176, pic_height, (unsigned char *)bmp_leaf_4bit );
            LCD.update();
        }
        wait(0.8);
        
        LCD.fillcircle(  40, 136, 18, LCD_COLOR_WHITE );
        LCD.update();
        wait(1); 
        LCD.fillcircle( 160, 122, 12, LCD_COLOR_WHITE );
        LCD.update();
        wait(0.2); 
        LCD.fillcircle( 120, 132, 14, LCD_COLOR_WHITE );
        LCD.update();   
        wait(1); 
                
        LCD.setBlinkMode( LCD_BLINKMODE_INVERSE );
        wait(0.2); 
        LCD.setBlinkMode( LCD_BLINKMODE_NONE );
        wait(0.2);        
       
        /*  Cube  */
        LCD.background( LCD_COLOR_WHITE);        
        for(k=0; k<7; k++){ // 6 times
            for(j=0; j<Divide; j++){
                LCD.window(0, j*Block, LCD_DISP_WIDTH, Block);
                for(i=0; i<4; i++){
                    LCD.foreground( ((j+1+ k*(i*5))%6 +1) << 1 );  // except White & Black  ( )%6 +1                    
                    if((j+k)%2) LCD.symbol( i*44, j*Block, (unsigned char *)symb_block );
                    else        LCD.symbol( i*44, j*Block, (unsigned char *)symb_block_rev );
                }
                LCD.update();
            }
            wait(0.2);
            LCD.setBlinkMode( LCD_BLINKMODE_INVERSE );
            wait(0.2); 
            LCD.setBlinkMode( LCD_BLINKMODE_NONE );
            wait(0.2);     
        }
        wait(0.5); 
           
        /*  Watch  */
        LCD.background( LCD_COLOR_WHITE); 
        for(j=0; j<Divide; j++){
            LCD.window(0, j*Block, LCD_DISP_WIDTH, Block);
            LCD.Bitmap4bit( 0, 0, 176, 176, (unsigned char *)bmp_watch_4bit );
            LCD.update();
        }
        LCD.foreground( LCD_COLOR_BLUE );
        LCD.window( 0, 54, LCD_DISP_WIDTH, 25);
        LCD.Bitmap4bit( 0, 0, 176, 176, (unsigned char *)bmp_watch_4bit ); // window back screen
        LCD.set_font( (unsigned char*)Prototype_num21x25 );
        LCD.locate(22, 54);        
        LCD.printf("10:");
        for(k=0; k<40;k++){
            LCD.locate(72, 54);        
            LCD.printf("%02d",k+20);
            LCD.update();
            wait((double)exp((double)(-k/3))); // time constant =3
        }
    }
}
