#include "mbed.h"
#include "SB1602E.h"
#define USE_I2C_2V8

DigitalOut myled(P0_8); // 7=rot, 8=grün, 9=blau
InterruptIn sw_o(P0_12);
InterruptIn sw_b(P0_13);
InterruptIn sw_g(P0_14);
Timer t1;  // ein (globaler) Timer für alle Tasten

I2C i2c_disp(P0_5, P0_4); //  SDA, SCL auf LPC11U24
SB1602E lcd(i2c_disp);

int count_o = 0, count_b = 0, count_g = 0;
int lastMS_o = 0, lastMS_b = 0, lastMS_g = 0;  // Timer-Werte beim letzten Interrupt in [ms]

void incrementO() {
    //t1.start();  // startet beim ersten Aufruf den Timer, bei weiteren Aufrufen passiert nichts (Timer läuft weiter)
    
    if (t1.read_ms() - lastMS_o > 10) {  // ist die Differenz zwischen aktueller Zeit und letztem Aufruf > 10ms ...
        count_o++;                       // ... dann inkrementiere die Zählervariable
    }  
    lastMS_o = t1.read_ms();  // speichert den aktuellen Timer-Wert (für den nächsten Aufruf/Taster-Interrupt)
}

void incrementB() {
    t1.reset();
    if (t1.read_ms() - lastMS_b > 10) count_b++;   
    lastMS_b = t1.read_ms();
}

void incrementG() {
    if (t1.read_ms() - lastMS_g > 10) count_g++; 
    lastMS_g = t1.read_ms();
}

int main() {    
    sw_o.mode(PullUp);
    sw_g.mode(PullUp);
    sw_b.mode(PullUp);
    
    sw_o.fall(&incrementO);
    sw_b.fall(&incrementB);
    sw_g.fall(&incrementG);
    
    lcd.printf(0, "Red Blue Green\r");    //  Parameter von printf auf LCD: Zeilennummer (0 or 1), string
    
    t1.start();

    while(1) {
        myled = !myled;
        lcd.printf(1, 1, "%d   %d   %d", count_o, count_b, count_g);
    }
}