#include "mbed.h"

class DebounceIn : public DigitalIn
{
    public:
    Ticker ticker;
    int    shadow;
    int    counter;
    int    samples;
    
public:

    /* Setzt die Entprellzeit (in µs), default sind 1000µs (1ms) */
    void set_debounce_us(int i) {
     ticker.attach_us(callback(this,&DebounceIn::cb), i);
    //ticker.attach_us(this, &DebounceIn::cb, i);
    //ticker.attach_us(&DebounceIn::cb, i);
    }

    /* Definiert die Anzahl der Samples um den 'Schatten'-Zustand des DigitalIn-Pins zu schalten */
    void set_samples(int i) {
        samples = i;
    }

    /* Liest den Wert des entprellten Pins */
    int Read(void) {
        return shadow;
    }

//#ifdef MBED_OPERATORS
       operator int() { return Read(); }
//#endif

    /* Konstruktor */
    DebounceIn(PinName pin) : DigitalIn(pin) {
        counter = 0;
        samples = 10;
        // shadow = 0;
        set_debounce_us(1000);
    }

    

protected:

    void cb() {
        if (!DigitalIn::read()) {
            if (counter < samples) counter++;
            if (counter == samples) shadow = 1;
        } else {
            if (counter > 0) counter--;
            if (counter == 0) shadow = 0;
        }
    }


};