#include "mbed.h"
#include "freetronicsLCDShield.h"

/* These are the custom chars 8 of them 1 per row.                  */
const char CGRAM_DATA[64]={0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,
                           0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0x1F,
                           0x00,0x00,0x00,0x00,0x00,0x1F,0x1F,0x1F,
                           0x00,0x00,0x00,0x00,0x1F,0x1F,0x1F,0x1F,
                           0x00,0x00,0x00,0x1F,0x1F,0x1F,0x1F,0x1F,
                           0x00,0x00,0x1F,0x1F,0x1F,0x1F,0x1F,0x1F,
                           0x00,0x1F,0x1F,0x1F,0x1F,0x1F,0x1F,0x1F,
                           0x1F,0x1F,0x1F,0x1F,0x1F,0x1F,0x1F,0x1F};

/* Create a freetronics LCD Shield object named LCD                 */
/* freetronicsLCDShield LCD(rs, e, d0, d1, d2, d3, bl, a0);         */
/* These are the connections for the Arduino footprint on the KL25Z */
freetronicsLCDShield LCD(PTA13, PTD5, PTA4, PTA5, PTC8, PTC9, PTA12, PTB0);

int main() {
    // Write custom generated chars to the 
    LCD.writeCGRAM (0x00, &CGRAM_DATA[0], 8);
    LCD.writeCGRAM (0x08, &CGRAM_DATA[8], 8);
    LCD.writeCGRAM (0x10, &CGRAM_DATA[16], 8);
    LCD.writeCGRAM (0x18, &CGRAM_DATA[24], 8);
    LCD.writeCGRAM (0x20, &CGRAM_DATA[32], 8);
    LCD.writeCGRAM (0x28, &CGRAM_DATA[40], 8);
    LCD.writeCGRAM (0x30, &CGRAM_DATA[48], 8);
    LCD.writeCGRAM (0x38, &CGRAM_DATA[56], 8);
    
    LCD.cls();
    
    
    // The backlight can be turned on or off //
    LCD.setBackLight(true); wait(2.0); 
    // The setBackLight method is overloaded so you can specify it's intensity by supplying it with a float value
    LCD.setBackLight((float) 0.05);
    
    while (true) {
        LCD.cls();
        LCD.setCursor(false);
        // You may want to set the cursor position at a specific location
        LCD.setCursorPosition (0, 0);
        LCD.printf("* Hello  world *");
    
        // Shift the text on the LCD left ...
        for(int i = 0; i < 3; i++) {LCD.shift(true); wait(0.5);}
        
        // Shift right ...
        for(int i = 0; i < 6; i++) {LCD.shift(false); wait(0.5);}
        
        // Shift the text back to left ...
        for(int i = 0; i < 3; i++) {LCD.shift(true); wait(0.5);}
        
        LCD.setCursorPosition (1,0);
        // Let the cursor blink 
        LCD.setCursor(true, true);
        LCD.putc('A'); wait(0.5);    
        LCD.putc('w'); wait(0.5);     
        LCD.putc('e'); wait(0.5);    
        LCD.putc('s'); wait(0.5);    
        LCD.putc('o'); wait(0.5);    
        LCD.putc('m'); wait(0.5);    
        LCD.putc('e'); wait(0.5);    
        
        LCD.cls();
        LCD.setCursor(false);
        // You may want to set the cursor position at a specific location
        LCD.setCursorPosition (0, 0);
        LCD.printf("Backlight = %0.3f", 0.000);
        int n = 0;

        for (float intensity = 0.125; intensity <= 1.0; intensity += 0.125) {
           // Fire up the backlight 
            LCD.setBackLight((float) intensity);
            // Display intensity
            LCD.setCursorPosition(0,11);
            LCD.printf("%0.3f", intensity);
            
            // Print the custom char's 0 .. 7
            LCD.setCursorPosition(1,4+n);
            LCD.putc(n);
            n++;
            wait(0.5);
        } 
   }
}
