
//This program is for a 1 mV FS datalogger 

#include "mbed.h"
#include "USBSerial.h"
Serial pc(USBTX, USBRX);
DigitalOut d1(p15); 
AnalogIn input1(p16);  
DigitalOut d2(p17);  
DigitalOut d3(p18);
DigitalOut d4(p19);  
DigitalOut d5(p20);

PwmOut OUToffset(p23); 
PwmOut INoffset(p21);
PwmOut myled1(LED1);       //P26
PwmOut myled2(LED2);       //P25
PwmOut myled3(LED3);       //P24        
//Don't use LED4, it is connected to PWMout P23!!

DigitalOut mux0(p27);
DigitalOut mux1(p28);
DigitalOut mux2(p29);
DigitalOut mux3(p30);

char ch;
unsigned short mvolts1; 
unsigned short mvolts2; 
unsigned short mvolts3; 

//offset Control
float Offset_A = 0.5;        //in offset  p21
float Offset_B = 0.5;        // out offset p23
float Stime = .05;
float Sgain = 1;

void rec_param(float *Offset_A, float *Offset_B, float *Stime, float *Sgain)
{  
    pc.putc(0x0C);           // Write to computer serial port
    ch = pc.getc();
    while (ch != ' ')  {
        ch = pc.getc();
    }
    pc.scanf("%f %f %f %f", Offset_A, Offset_B, Stime, Sgain);  
    myled1 = 1;                                                  
    wait(0.2);
    return;
}

main(void) {
    
    mux0 = 0;    
    mux1 = 1;    
    mux2 = 0;   
    mux3 = 0;   
         
    OUToffset.period_us(100);
    INoffset.period_us(100);

// Default offsets
    INoffset = 50.;        
    OUToffset = 50.;        
 
// Read initial offset and sample time
    rec_param(&Offset_A,&Offset_B, &Stime, &Sgain); 
    wait(0.2);
    INoffset = Offset_A/100.;        
    OUToffset = Offset_B/100.;     
    myled1= 0;  
                                               
//Read character 
    while (1) {                
        if(pc.readable()) {
            myled2 = myled3 = 0;
            ch = pc.getc();
//Read setup parameters
            if (ch == 'X') {
               myled2 = 1;                                                    
                rec_param(&Offset_A,&Offset_B, &Stime, &Sgain); 
                wait(0.2);
                INoffset = Offset_A/100.;         
                OUToffset = Offset_B/100.;             
                
              if (Sgain == 1){
                    mux0 = 0;    
                    mux1 = 0;  }                
                else if (Sgain == 10){
                    mux0 = 0;    
                    mux1 = 1;}
                else if (Sgain == 100){
                    mux0 = 1;    
                    mux1 = 0; }     
                else {
                    mux0 = 1;    
                    mux1 = 1;}  
                                
                myled1 = myled2 = 0;                          
                ch = ' ';
            }
  
//Sample Data
            if (ch == 'S') {
              for(int i = 1; i < 4 ; i++) {
                wait(Stime/3000);
                mvolts1 = input1.read_u16();
                mvolts2 = input1.read_u16();
                mvolts3 = input1.read_u16();                
              if ((mvolts1 >= mvolts2 && mvolts1 <= mvolts3) || (mvolts1 >= mvolts3 && mvolts1 <= mvolts2)) mvolts = mvolts1;
                else if ((mvolts2 >= mvolts1 && mvolts2 <= mvolts3) || (mvolts2 >= mvolts3 && mvolts2 <= mvolts1)) mvolts = mvolts2;
                else mvolts = mvolts3;                        
                    
                    pc.putc((mvolts>>8)&0xFF);
                    pc.putc((mvolts>>0)&0xFF);
              }  //end for
             }  // end if
//Check for stop
            if (ch == 'Q') {
                wait(1);
                ch = ' ';
            }             
                                                                                                            
          }  //pc readable 
      }      //while
}
