#include "mbed.h"
#include "ble/BLE.h"

Ticker sensorPollingTicker;
static bool sensorPollingTrigger = false;

DigitalOut led(LED1, 1);
uint16_t customServiceUUID  = 0xEB00;
uint16_t readCharUUID       = 0xEB03;
uint16_t writeCharUUID      = 0xEB02;
uint16_t temperatureUUID    = 0xEB01;



const static char     DEVICE_NAME[]        = "ChangeMe!!"; // change this
static const uint16_t uuid16_list[]        = {0xFFFF}; //Custom UUID, FFFF is reserved for development

/* Set Up custom Characteristics */
static uint8_t readValue[10] = {0};
ReadOnlyArrayGattCharacteristic<uint8_t, sizeof(readValue)> readChar(readCharUUID, readValue);

static uint8_t writeValue[10] = {0};
WriteOnlyArrayGattCharacteristic<uint8_t, sizeof(writeValue)> writeChar(writeCharUUID, writeValue);

static uint8_t temperatureValue[3] = {0};
ReadOnlyArrayGattCharacteristic<uint8_t, sizeof(temperatureValue)> readTemperature(temperatureUUID, temperatureValue);

/* Set up custom service */
GattCharacteristic *characteristics[] = {&readChar, &writeChar, &readTemperature};
GattService        customService(customServiceUUID, characteristics, sizeof(characteristics) / sizeof(GattCharacteristic *));


/*
 *  Restart advertising when phone app disconnects
*/
void disconnectionCallback(const Gap::DisconnectionCallbackParams_t *)
{
    BLE::Instance(BLE::DEFAULT_INSTANCE).gap().startAdvertising();
}

/*
 *  Handle writes to writeCharacteristic
*/
void writeCharCallback(const GattWriteCallbackParams *params)
{
    /* Check to see what characteristic was written, by handle */
    if(params->handle == writeChar.getValueHandle()) {
        /* toggle LED if only 1 byte is written */
        if(params->len == 1) {
            led = params->data[0];
            printf("data is: %d\n", params->data[0]);
            (params->data[0] == 0x00) ? printf("led on\n\r") : printf("led off\n\r"); // print led toggle
            
            if(params->data[0] == 0x01 || params->data[0] == 49) //character 1 or 0x01
            {
                led = 1;
            }
            else
                led = 0;
        }
        /* Print the data if more than 1 byte is written */
        else {
            printf("Data received: length = %d, data = 0x",params->len);
            for(int x=0; x < params->len; x++) {
                printf("%x", params->data[x]);
            }
            printf("\n\r");
        }
        /* Update the readChar with the value of writeChar */
        //BLE::Instance(BLE::DEFAULT_INSTANCE).gattServer().write(readChar.getValueHandle(), params->data, params->len);
    }
}
/*
 * Initialization callback
 */
void bleInitComplete(BLE::InitializationCompleteCallbackContext *params)
{
    BLE &ble          = params->ble;
    ble_error_t error = params->error;
    
    if (error != BLE_ERROR_NONE) {
        return;
    }

    ble.gap().onDisconnection(disconnectionCallback);
    ble.gattServer().onDataWritten(writeCharCallback);

    /* Setup advertising */
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED | GapAdvertisingData::LE_GENERAL_DISCOVERABLE); // BLE only, no classic BT
    ble.gap().setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED); // advertising type
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME, (uint8_t *)DEVICE_NAME, sizeof(DEVICE_NAME)); // add name
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_16BIT_SERVICE_IDS, (uint8_t *)uuid16_list, sizeof(uuid16_list)); // UUID's broadcast in advertising packet
    ble.gap().setAdvertisingInterval(100); // 100ms.

    /* Add our custom service */
    ble.addService(customService);

    /* Start advertising */
    ble.gap().startAdvertising();
}

void sensorPollingCallback()
{
    temperatureValue[0]++;
    temperatureValue[1] = temperatureValue[0] +1;
    temperatureValue[2] = temperatureValue[0] +2;
    if(temperatureValue[0] >= 100)
    {
        temperatureValue[0] = 1;
        temperatureValue[1] = temperatureValue[0] +1;
        temperatureValue[2] = temperatureValue[0] +2;
    }
    //led = ! led;    
    sensorPollingTrigger = true;
}

/*
 *  Main loop
*/
int main(void)
{
    /* initialize stuff */
    printf("\n\r********* Starting Main Loop *********\n\r");
    
    
    sensorPollingTicker.attach(sensorPollingCallback,5);
    
    BLE& ble = BLE::Instance(BLE::DEFAULT_INSTANCE);
    ble.init(bleInitComplete);
    
    /* SpinWait for initialization to complete. This is necessary because the
     * BLE object is used in the main loop below. */
    while (ble.hasInitialized()  == false) { /* spin loop */ }

    /* Infinite loop waiting for BLE interrupt events */
    while (true) {
        
        if(sensorPollingTrigger == true && ble.getGapState().connected == true)
        {
            
            
            sensorPollingTrigger = false;
            
            
            ble.gattServer().write(readTemperature.getValueHandle(), temperatureValue, sizeof(temperatureValue));
            
            //BLE::Instance(BLE::DEFAULT_INSTANCE).gattServer().write(readChar.getValueHandle(), readValue, 1);
            printf("data is sent: %d\n\r", temperatureValue[0]);
            printf("size is: %d\n\r", sizeof(temperatureValue));
        }
        else
        {
            ble.waitForEvent(); /* Save power */
        }
    }
}