#include "mbed.h"
#include "stdio.h"
/*ドップラーシフト対策  calsatが計算した周波数のデータを受け取る*/
Serial pc(SERIAL_TX, SERIAL_RX,921600);
Serial device(PA_9,PA_10,9600);
#define kHz 1000
#define MHz 1000000
 int Integer_N = 0; 
 int Fractional_N = 0;
 int intbin[7]={0};
 int decbin[14]={0};

int doppler(char *a)  //データを取得し、出力する関数
{
    int data[10] = {0};
    int doppler_data = 0;
    int flag = 0;
    for(int i = 5; i < 10; i++) {
        char c = a[i];
        data[flag] = (c >> 4) & 0xf;
        data[flag+1] = c & 0xf;
        flag += 2;
    }

    for(int i = 0; i < 10 ; i++)
    //    printf("%d ", data[i]);
   // printf("\r\n");

    doppler_data = 10 * data[0] + data[1] + kHz * data[2] + 100 * data[3] + 100*kHz * data[4] + 10*kHz * data[5] + 10*MHz * data[6] + MHz * data[7] + data[8] + 100*MHz * data[9];
    printf("\n%d\n",doppler_data);

    return doppler_data;

}

void binary(int a){ //2進数に変換する関数
 if(a == Fractional_N){ //小数部分の変換
   for(int i=0;Fractional_N>0;i++){
     decbin[i] = Fractional_N % 2;
     Fractional_N = Fractional_N / 2;
    }
   printf(" 小数部の2進数 = ");
   int l = 15;
   while( l>0 ){
    printf("%d", decbin[--l]);/* 2進数の出力 */
    printf("\n");
   }
  }else{　//整数部分の計算
   for(int i=0;Integer_N >0;i++){
     intbin[i] = Integer_N % 2;
     Integer_N = Integer_N / 2;
   }
   printf(" 整数部の2進数 = ");
   
   int k = 8;
   while( k>0 ){
   printf("%d", intbin[--k]);/* 2進数の出力 */
    printf("\n");
  }
 }
 }
 
int main()
{

    while(1) {
        char command[128] = {'0'};
        char c = device.getc();
        int i = 1;
        if(c == 0xfe) { //FEコマンドがきたらdataが始まる
            command[0] = c;

            while(c != 0xfd) {
                c = device.getc();
                command[i] = c;
                i++;
            }
            //ここまでで一旦プリアンブルからポストアンブルまでをcommandに格納する
            //表示確認

            for(int j = 0; j < i; j++)
             //   printf("%02hhx",command[j]);
          //  printf("\r\n");

            if(command[4] == 0x00)
                float num = doppler(command);   //calsatから受け取った10進数のデータ
          
           double n = num * 2 / 19.68; //変換式
           Integer_N = (int)n; //
           Fractional_N = (n - Integer_N)*32768;
    
           binary(Fractional_N);
           binary(Integer_N);
 
    return 0;
        }
    }
}


 

