#include <mbed.h>
#include <stdio.h>
#include <stdlib.h>
Serial pc(USBTX, USBRX,921600);
Serial device( p9, p10, 9600);
#define kHz 1000
#define MHz 1000000
#define PFD 19.68
LocalFileSystem local("local");
#pragma diag_suppress 870

class calsat32
{
public:
    int Fractional_N;
    int Integer_N;
    int intbin[8];
    int decbin[15];
    int register_data;//レジスタへ入れるファイルから読み込んだ10進数の値
    int length; //値の長さ
    int size;//累計の長さこれが32となったら1つのレジスタの設定が完了として次のレジスタの設定へ移る
    int register_num;//レジスタ番号
    int buf;
    char _command[128];
    double human_doppler; //人から受け取る周波数の値
    uint32_t _register;//最終的に欲しいレジスタの値.32ビット
    uint32_t register_data_array[16];//完成したレジスターを格納する配列sho
    const char* filename;
    FILE *fp;

    calsat32()
    {
        Fractional_N = 0;
        Integer_N = 0;
        register_data = 0;//レジスタへ入れる1ファイルから読み込んだ10進数の値
        length = 0; //値の長さ
        size = 0;//累計の長さこれが32となったら1つのレジスタの設定が完了として次のレジスタの設定へ移る
        register_num = 1;//レジスタ番号
        filename = "/local/register.tsv";
        _register = 0;
        human_doppler = 0;
    }
    //main関数内でコマンドが0x00の時にmainでbinary()を呼ぶと計算をしてuint_32型の値を返す

    /*void Reg0_gen(int key,double doppler_data ){ //keyはコマンド
        if(key == 1) {

               Shift_bit(_register, binary(doppler_data), 4);
               size = 27;
           }

         else if(key ==2){ //calsatから受けとる
          Shift_bit(_register, binary(human_doppler), 4);//1の時calsat,２の時人
          size = 27;
         }
          else if(key == 3 || key == 0) {
               uint32_t tmp = 0;
               tmp |= ( register_data_array[2] >> 27); //この行と次の行でレジスタのデータの部分を全て0にしている
               tmp |= (tmp << 27);
               size = 27;
               if(key == 3){
               Shift_bit(tmp, binary(human_doppler), 4);//人間が入力した周波数の値を用いたレジスタを作成する
               register_data_array[2] = tmp;//配列の中に格納する
               show_all();
               }

           }else {}
    }*/
    void Shift_bit(uint32_t& Register, int Register_data, int Size)
    {
        Register |= (Register_data << Size);
    }

    void file_read(char* command,int key)
    {
        /* ファイルのオープン */
        char name[100] = {};//出力はしない
        if ((fp = fopen("/local/register.tsv", "r")) == NULL) {
            fprintf(stderr, "%sのオープンに失敗しました.\r\n", filename);
            exit(EXIT_FAILURE);
        }

        /* ファイルの終端まで文字を読み取り表示する */
        int num[5] = {1,3,0,5,4};
        int l = 1;//行数
        uint32_t _register = 0;//最終的に欲しいレジスタの値.32ビット

        while ( fscanf(fp,"%s%d%d%d",name, &register_data,&length,&buf) != EOF ) {
            if(l == 1 || l == 14  || l == 21 ||l == 27 || l == 37) {
                printf("%d\r\n",l);
                l++;

            } else {
                printf(" %d %d   %d \r\n",register_data, length,size);


                if(l==23) {
                        
                    Shift_bit(_register, binary(command), 4);
                    size = 27;
                    /* else if(key == 2){
                        human_doppler = register_data;
                       // Shift_bit(_register, binary(register_data), 4);
                    }
                       double doppler_data;
                        doppler_data = doppler(_command);
                      Reg0_gen(key,doppler_data);*/

                    //テキストファイルから受け取った値を格納するとき
                } else {
                    Shift_bit(_register, register_data, size);
                    size += length;

                    if(register_num == 1 && size == 26) {
                        printf(" = reg_%d ",num[register_num - 1]);
                        show(_register);
                        register_num++;
                        _register = 0;
                        size = 0;
                    }
                    if(size == 32) {
                        //これで一つ完成.この値をどういう風にやるかは未定show()みたいなのを作るか？
                        printf(" = reg_%d ",num[register_num - 1]);
                        show(_register);
                        register_num++;
                        _register = 0;
                        size = 0;
                    }
                }
                l++;
            }
        }

        /* ファイルのクローズ */
        fclose(fp);
    }

    uint32_t binary(char* command)
    {
        double  RFout = doppler(command);
        double n = RFout * 2 / PFD;
        Integer_N = (int)n;
        double test = (n - (int)n);
        Fractional_N = test*32768;

        uint32_t data = Fractional_N;
        return data |= (Integer_N << 15);//レジスタ入力に適した形にした23桁の2進数を返す
    }
    //データを取得し返す関数
    double doppler(char *a)
    {
        int data[10] = {0};
        double doppler_data = 0;
        int flag = 0;
        for(int i = 5; i < 10; i++) {
            char c = a[i];
            data[flag] = (c >> 4) & 0xf;
            data[flag+1] = c & 0xf;
            flag += 2;
        }

        doppler_data = 10 * data[0] + data[1] + kHz * data[2] + 100 * data[3] + 100*kHz * data[4] + 10*kHz * data[5] + 10*MHz * data[6] + MHz * data[7] + data[8] + 100*MHz * data[9];//Hz
        printf("\n%lf\r\n",doppler_data / 1000000); //Mhz

        return doppler_data / 1000000;
    }
    void show(uint32_t bin)
    {
        static int reg_num = 0;
        //表示フェーズ
        for(int i = 32; i > 0; i--) {
            if(bin & (1 << (i - 1))) {
                pc.printf("1");
            } else {
                pc.printf("0");
            }
        }
        printf("\r\n");

        //格納フェーズ
        register_data_array[reg_num] = bin;
        reg_num++;
        if(reg_num == 4) {
            reg_num = 0;
        }
    }

    void show_all()//完成したレジスタの値を出力
    {
        for(int j = 0; j < 5; j++) {
            for(int i = 32; i > 0; i--) {
                if(register_data_array[j] & (1 << (i - 1))) {
                    pc.printf("1");
                } else {
                    pc.printf("0");
                }
            }
            printf("\r\n");
        }
    }
    void packet(char c)
    {
        static int a = 0;
        _command[a] = c;
        a++;

        if(_command[a-1] == 0xfd) {
            /*
            for(int j = 0; j < a; j++)
                printf("%02hhx",_command[j]);
            printf("\r\n");
            */
            a = 0;

        }
    }

    void check(char key)

    {
        printf("%c",key);
        if(_command[4] == 0x00) {
            printf("---------------------------Start-----------------------------\r\n");
            file_read(_command,key);
        }
    }

};



int main()
{
    Serial device( p9, p10, 9600);
    while(1) {
        calsat32 tmp;
        while(device.readable()) {
            char c = device.getc();
            tmp.packet(c);
            if(pc.readable()) {
                char key = pc.getc();
                tmp.check(key);
            }

        }
    }
    return 0;
}
