#include "Dashboard.h"
#include "mbed.h"

#define SIG_RX_CAN  0x01
#define SIG_AFF 0x01

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);

Thread threadA;
Thread threadB;

CAN CanPort(p30, p29);
CANMessage  MessageRx; 
Dashboard dshbd(p28, p27);

signed char dataToPrint[8];

void canReader(void)
{
    if (CanPort.read(MessageRx))
    {
            led1 = !led1;
            threadA.signal_set(SIG_RX_CAN);
    }
} 

void readFrame(CANMessage msg){
    if(msg.id==2){
        int i=0;
        for(i=0;i<8;i++){
            dataToPrint[i]=msg.data[i];
        }
    }    
}

void thA() 
{
    while(true)
    {
        Thread::signal_wait(SIG_RX_CAN);  
        readFrame(MessageRx);  
        led2 = !led2;
        threadB.signal_set(SIG_AFF);
        //printf("RX FRAME ID = %X\n",MessageRx.id);
    }
}

void thB() 
{
    //int i=0;
    while(true){
        Thread::signal_wait(SIG_AFF);
        led3 = !led3;
        dshbd.clear();
        dshbd.printData(dataToPrint);
        dshbd.changeColor(dataToPrint[0]);
        //wait(5);
        /*i++;
        if(i>7){i=0;}*/
        //printData();
    }
}

int main()
{
   //Init CAN
   CanPort.frequency(20000);
   //Init LCD 
   dshbd.setRGB(0xff, 0xff, 0xff);                 //set the color 
   dshbd.print("Init System !");
   dshbd.locate(0,1);
   wait(5);
   
   CanPort.attach(canReader,CAN::RxIrq);
        
   threadA.start(thA);
   threadB.start(thB);

   while(1)
   {
    
     
   }
}

