#include "mbed.h"
#include "Dashboard.h"
#include <string>

Dashboard::Dashboard(PinName sda, PinName scl):Grove_LCD_RGB_Backlight(sda,scl)
{
    this->init();
};

void Dashboard::printData(signed char *str)
{
    char result[32];
    signed char temperature = str[0];
    char hygrometrie = str[3];
    int pression = (str[1]<<8) + str[2];
    
    sprintf(result, "T: %d  H: %d",temperature,hygrometrie);
    this->locate(0,0);
    this->print(result);
    
    sprintf(result, "P : %d",pression);
    this->locate(0,1);
    this->print(result);
}

void Dashboard::changeColor(signed char temp)
{
    if(temp<0){
        temp=temp+10;
    }
    this->setRGB(temp,0,40-temp);
}



