#ifndef UTILS_H
#define UTILS_H

#include "mbed.h"

//uController pin definitions
//inputs
#define TACH PTB0
#define STEER_LEFT PTB2
#define STEER_RIGHT PTB3
//outputs
#define SPEED_CONTROL PTA5
#define SERVO PTA4
#define BRAKE PTA12
 //serial
#define BT_TX PTE0
#define BT_RX PTE1

//constants
#define TI 0.001f

#define KPS 0.0896852742245504f
#define KD 0.072870569295611f
#define SET 0.0f
#define MAXs 0.1f
#define MINs 0.05f
#define BIAS 0.075f
#define TOL 0.002f

#define SCALAR 0.6f
#define MAXm 1.0f
#define MINm 0.0f
#define KPm 0.1414f
#define KI 19.7408f

//System I/O
extern AnalogIn speed;
extern AnalogIn RSensor;
extern AnalogIn LSensor;

extern PwmOut gateDrive;
extern PwmOut servoSig;
extern DigitalOut brake;

/*
    Contains general utilities to be used for the autonomous car. Basically a 
    catch all category for stuff not in another namespace. 
*/
namespace Car
{      
    /* 
        Moving average filter. Breaks program for some reason so not currently in use
    */
    float filter_input(AnalogIn input, int filterLength);
    
    /*   
    Increment a value by a specified amount with bounded output
    */
    float increment_with_bound(float val, float upper, float increment);
    /*   
    Decrement a value by a specified amount with bounded output
    */
    float decrement_with_bound(float val, float lower, float decrement);
};

/*
    Contains control algorithms and state machine logic
*/
namespace Control
{    

    
    /*  
    **********compiler annoyance
    These are at namespace scope so we must declare them here and specify that they
    are instantiated elsewhere (utils.cpp) with 'extern'
    Otherwise the compiler tries to make multiple copies which it can't
    */
    //PI controller vaiables
    extern float motor_setpoint;
    extern float errSum;
    
    //PD controller variables
    //extern float steerValue;
    //extern float distanc;
    extern float e;
    extern float ep;
    //extern float output;
    //extern float derivative;
    extern float Controlleroutput;
    extern float prevOutput;
        
    extern Ticker sample;
    
    /*    
    Compute PI controller gain
    */
    void compute_PI();
    
    /*  
    Compute PD controller gain
    */
    void compute_PD();
    
    //Start and stop automatic control of the car
    void run();
    void stop();
    
    //functions to be called by interrupts
    void control_cb();  
};

/*
    Handles serial Communication and data formatting
*/
namespace Data
{
     const unsigned int BAUD_RATE = 115200;
     
     extern Serial bt;
     
     void serial_cb();
     
     void start_bt();
}
#endif