

// My first code for the mbed.
// Blinks "HELLO WORLD" out in Morse Code on LED1
// Repeats forever
//


#include "mbed.h"

#define WAIT_time 0.20      // about 5 wpm
#define D() wait(WAIT_time)

DigitalOut myled1(LED1);


void send_dah();
void send_dit();
void send_space();
void send_morse(char);
void blink_out(char *ptr);
 
 
char temp1;
char rotate_char;
char loops;
char morse;
 
 
 
// Offset 0x2C for ASCII to Morse code character pattern conversion
// 0xFF means it is not a valid Morse code character

// Characters are packed this way: Bits are rotated right until a "1". After that, "1" is a Dah, "0" is a Dit.
// So, pad the LSBits with "0"s until the 8 bits represent a valid Morse Code charater.
char mcode[100]=
{
 0xCE,0xFF,0xAA,0xFF,
 0xFC,0xF4,0xE4,0xC4,0x84,0x04,0x0C,0x1C,0x3C,0x7C,     
 0xFF,0xFF,0xFF,0xFF,0xFF,0x32,0xFF,
 
 0xA0,0x18,0x58,0x30,0x40,0x48,0x70,0x08,0x20,0xE8,
 0xB0,0x28,0xE0,0x60,0xF0,0x68,0xB1,0x50,0x10,0xC0,
 0x90,0x81,0xD0,0x91,0xD8,0x31,

 0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,

 0xA0,0x18,0x58,0x30,0x40,0x48,0x70,0x08,0x20,0xE8,
 0xB0,0x28,0xE0,0x60,0xF0,0x68,0xB1,0x50,0x10,0xC0,
 0x90,0x81,0xD0,0x91,0xD8,0x31,
};



int main() {

    myled1 = 0;
    
    while(1) {
        blink_out("HELLO WORLD");
        send_space();

    }   
      
}        
        
        
void send_morse(char morse) {
        
    rotate_char = 0x01;            // set up mask bit 
    loops = 0x00;
    do {
        rotate_char <<= 1;
        loops++;
    }while ((morse & rotate_char) == 0);
        
    rotate_char <<= 1;
    loops++;

    do {
        if ((morse & rotate_char) == 0)       // if it is a zero, send a dit
            send_dit();

        else
            send_dah();
        
        rotate_char <<= 1;
        loops++;
    
    }while(loops < 8);                  // there are 8 bits 

}



void send_dit() {                      // dit is on one unit, off one unit 

    myled1 = 1;
    D();
    myled1 = 0;
    D();
   
}


void send_dah() {                      // dah is on 2 units, off 1 unit 

    myled1 = 1;
    D();
    D();
    myled1 = 0;
    D();
    
   
}

void send_space() {                   // space between words is 7 units 

    D();
    D();
    D();
    D();
    D();
    D();
    D();

}    


void blink_out(char *ptr) {

    while (*ptr)
        {temp1 = *ptr++;
       
        if (temp1 == 0x20)
                {send_space();
                temp1 = *ptr++;
                };
            
        temp1-= 0x2C;                       
        morse = mcode[temp1];
        send_morse(morse);
        D();                                // 2 unit space
        D();
        }
}



