#include "mbed.h"
#include "Servo.h"
#include "mbed_rpc.h"

/* Virtual USB serial port */
Serial pc(USBTX, USBRX); // tx, rx
 
/* Declare all servos */
Servo servo_ingredient0(p21);
Servo servo_ingredient1(p22);
Servo servo_ingredient2(p23);
Servo servo_ingredient3(p24);
Servo servo_bread(p25);  

/* Time between opening and closing the ingredient dispenser */
int TIME_OPEN = 300;

/* Time after closing the ingredient dispenser */
int TIME_AFTER_CLOSING = 500;

/* For debugging purpose */
/* Output the ingredient code (which ingredients to dispense) onto LEDs */
BusOut mbed_leds(LED1, LED2, LED3, LED4);

/* Make sandwich, using ingredient code */
/*  Ingredient code is bit mask of ingredients needed */
/*  Bit 0 -> Ingredient 0 needed (1) or not (0) */
/*  Bit 1 -> Ingredient 0 needed (1) or not (0) */
/*  Bit 2 -> Ingredient 0 needed (1) or not (0) */
/*  Bit 3 -> Ingredient 0 needed (1) or not (0) */
void move_servos(int ingr_code) {
    /* Dispense bread */
    servo_bread = 0; /* Dispense bread */
    wait_ms(1000);
    servo_bread = 1; /* Reset position */
    wait_ms(1000);
    
     /* Dispense ingredient 0 */
    if (ingr_code & 0x1) {
        servo_ingredient0 = 1; /* Open */
        wait_ms(TIME_OPEN);
        servo_ingredient0 = 0; /* Close */
        wait_ms(TIME_AFTER_CLOSING);
    }
    /* Dispense ingredient 1 */
    if (ingr_code & 0x2) {
        servo_ingredient1 = 1; /* Open */
        wait_ms(TIME_OPEN);
        servo_ingredient1 = 0; /* Close */
        wait_ms(TIME_AFTER_CLOSING);
    }
    /* Dispense ingredient 2 */
    if (ingr_code & 0x4) {
        servo_ingredient2 = 1; /* Open */
        wait_ms(TIME_OPEN);
        servo_ingredient2 = 0; /* Close */
        wait_ms(TIME_AFTER_CLOSING);
    }
    /* Dispense ingredient 3 */
    if (ingr_code & 0x8) {
        servo_ingredient3 = 1; /* Open */
        wait_ms(TIME_OPEN);
        servo_ingredient3 = 0; /* Close */
        wait_ms(TIME_AFTER_CLOSING);
    }
    /* Dispense bread again */
    servo_bread = 0; /* Dispense bread */
    wait_ms(1000);
    servo_bread = 1; /* Reset position */
    wait_ms(1000);
}

/* Declare function 'm_sand' exposed via RPC */
void m_sand(Arguments *in, Reply *out);
RPCFunction rpc_m_sand(&m_sand, "m_sand");
void m_sand(Arguments *in, Reply *out)  {
        
    /* Get argument */
    int ingr_code = in->getArg<int>();
    
    /* Output to LEDs for debugging */
    mbed_leds = ingr_code;
    
    /* Execute the function */
    move_servos(ingr_code);
    
    /* Set output */
    out->putData("SandwichMade");
    
    /* Reset LEDs */
    mbed_leds = 0;    
}

/* Main code */
int main() {
    /* Set pc serial baud rate */
    pc.baud(9600);
 
    // receive commands, and send back the responses
    char buf[256], outbuf[256];
    
    while(1) {
        /* Wait for command */
        while (!pc.readable()) {
            wait_ms(100);
        }
        /* Read the characters into string array */
        int i = 0;
        while (pc.readable()) {
            buf[i] = pc.getc();
            i++;
        }
        buf[i] = '\n';
        pc.printf("%s", buf);
        //Call the static call method on the RPC class
        RPC::call(buf, outbuf); 
        pc.printf("%s\n", outbuf);
        /* Flush pc serial buffer */
        while (pc.readable()) {
            pc.getc();
        }
    }
    
}
