#include "ReadIntervals.h"
#include <algorithm>

int ReadIntervals::temperatureSensorPeriod_timeLeft = 0;
int ReadIntervals::batteryMonitorPeriod_timeLeft = 0;



void ReadIntervals::updateTimeLeft(const int & tickerSleptTime){
	temperatureSensorPeriod_timeLeft -= tickerSleptTime;
	batteryMonitorPeriod_timeLeft -= tickerSleptTime;
}

int ReadIntervals::getTickerSleepTime(){
	if(temperatureSensorPeriod_timeLeft <= 0){
		temperatureSensorPeriod_timeLeft += TemperatureSensorPeriod;
	}
	if(batteryMonitorPeriod_timeLeft <= 0){
		batteryMonitorPeriod_timeLeft += BatteryMonitorPeriod;
	}

	int ret = temperatureSensorPeriod_timeLeft;
	ret = std::min<int>(ret, batteryMonitorPeriod_timeLeft);
	
	ret = std::max<int>(ret, 1); 	//assert that ret != 0 or lower

	return ret;
}

bool ReadIntervals::temperatureSensorPeriodPassed(){
	return (temperatureSensorPeriod_timeLeft <= 0);
}
bool ReadIntervals::batteryMonitorPeriodPassed(){
	return (batteryMonitorPeriod_timeLeft <= 0);
}

