#ifndef UTIL_H
#define UTIL_H

#include <string>
// #include <vector>

template<typename T_FromType, typename T_ToType>
inline void castArray(T_FromType * fromArray, T_ToType * toArray, const unsigned int & length){
	for(unsigned int i=0; i < length; i++){
		toArray[i] = fromArray[i];
	}
}

// inline std::vector<std::string> split(std::string receivedMessage, const char & delimiter = ' '){
// 	std::vector<std::string> ret;
// 	size_t wordEnd = receivedMessage.find_first_of(delimiter);
// 	while(wordEnd != std::string::npos){
// 		std::string word = receivedMessage.substr(0, wordEnd);
// 		if(!word.empty()){
// 			ret.push_back(word);
// 		}
// 		receivedMessage = receivedMessage.substr(wordEnd+1);
// 		wordEnd = receivedMessage.find_first_of(delimiter);
// 	}
// 	if(!receivedMessage.empty()){
// 		ret.push_back(receivedMessage);
// 	}

// 	return ret;
// }


inline char digitToChar(uint8_t digit){
	return ('0' + digit); //ascii value + digit value = ascii value
}

inline std::string floatToString(float value, int maximumNumberOfDecimals = 5){	//Temporary solution to solve logging of float values
	//First make sure buffer is big enough
	std::string ret;
	int integersLength = 0;
	int valueInt = static_cast<int>(value);

	//integer part
	if(valueInt){
		integersLength = 1;
	}
	while(valueInt /= 10){   //assuming decimal system
		integersLength++;
		value /= 10.0f;
	}
	
	for(int i=0; i < integersLength; i++){
		uint8_t digit = (uint8_t) value;
		ret += digitToChar(digit);
		value -= digit;
		value *= 10.0f;
	}

	//decimal point
	ret += ".";
	
	//decimal part
	int decimalLength = 0;
	while((value != 0.0f) && (decimalLength < maximumNumberOfDecimals)){
		uint8_t digit = (uint8_t) value;
		ret += digitToChar(digit);
		decimalLength++;
		value -= digit;
		value *= 10.0f;
	}
	
	if((decimalLength == 0) && (decimalLength < maximumNumberOfDecimals)){
		ret += "0";
	}
	ret += "f";
	
	return ret;
}

#define floatToCharArray(...) floatToString(__VA_ARGS__).c_str()

#endif /* UTIL_H */
