
// t7utils.h - information and definitions needed for communicating with the T7 ECU

// (C) 2011, 2012 Sophie Dexter

#ifndef __T7UTILS_H__
#define __T7UTILS_H__

#include "mbed.h"

#include "common.h"
#include "canutils.h"

#define T7CMNDID 0x220
#define T7RESPID 0x238
#define T7SEC_ID 0x240
#define T7SEC_RX 0x258
#define T7ACK_ID 0x266
#define T7ANYMSG 0x0


// initialise T7

#define T7INITMSG   {0x3F,0x81,0x00,0x11,0x02,0x40,0x00,0x00}

// authenticate with T7

#define T7SEC_MSG   {0x40,0xA1,0x02,0x27,0x05,0x00,0x00,0x00}
#define T7KEY_MSG   {0x40,0xA1,0x04,0x27,0x06,0x00,0x00,0x00}

#define T7ACK_MSG   {0x40,0xA1,0x3F,0x00,0x00,0x00,0x00,0x00}

// read_trionic7

#define T7DMP_END   {0x40,0xA1,0x01,0x82,0x00,0x00,0x00,0x00}
//#define T7DMPJP1A   {0x41,0xA1,0x08,0x2C,0xF0,0x03,0x00,0xEF}    // 0x000000 length=0xEF
#define T7DMPJP1A   {0x41,0xA1,0x08,0x2C,0xF0,0x03,0x00,0x80}    // 0x000000 length=0x80 (128 bytes)
#define T7DMPJP1B   {0x00,0xA1,0x00,0x00,0x00,0x00,0x00,0x00}
#define T7DMPPOST   {0x40,0xA1,0x01,0x3E,0x00,0x00,0x00,0x00}
#define T7DMPDATA   {0x40,0xA1,0x02,0x21,0xF0,0x00,0x00,0x00}
#define T7DMP_ACK   {0x40,0xA1,0x20,0x00,0x00,0x00,0x00,0x00}

// flash_trionic7

#define T7FLASTRT   {0x41,0xA1,0x08,0x34,0x00,0x00,0x00,0x00}    // Start  = 0x000000
#define T7FLASIZE   {0x00,0xA1,0x00,0x00,0x00,0x00,0x00,0x00}    // Length = 0x000000
#define T7FLAJP1A   {0x41,0xA1,0x08,0x34,0x00,0x00,0x00,0x00}    // Start  = 0x000000
#define T7FLAJP1B   {0x00,0xA1,0x08,0x00,0x00,0x00,0x00,0x00}    // Length = 0x080000
#define T7FLABINA   {0x41,0xA1,0x08,0x34,0x00,0x00,0x00,0x00}    // Start  = 0x000000
#define T7FLABINB   {0x00,0xA1,0x07,0x00,0x00,0x00,0x00,0x00}    // Length = 0x070000
#define T7FLAHDRA   {0x41,0xA1,0x08,0x34,0x07,0xFF,0x00,0x00}    // Start  = 0x07FF00
#define T7FLAHDRB   {0x00,0xA1,0x00,0x01,0x00,0x00,0x00,0x00}    // Length = 0x000100
#define T7FLA_END   {0x40,0xA1,0x01,0x37,0x00,0x00,0x00,0x00}
#define T7FLAEXIT   {0x40,0xA1,0x02,0x31,0x54,0x00,0x00,0x00}
#define T7FLA_ACK   {0x40,0xA1,0x3F,0x00,0x00,0x00,0x00,0x00}        // 266h


#define T7MESSAGETIMEOUT 50             // 50 milliseconds (0.05 of a second) - Seems to be plenty of time to wait for messages on the CAN bus
#define T7LONGERTIMEOUT 500             // 500 milliseconds (0.5 of a second) - Some messages seem to need longer
#define T7CHECKSUMTIMEOUT 2000          // 2 seconds (2,000 milliseconds) - Usually takes less than a second so allowing 2 is plenty
#define T7CONNECTTIMEOUT 5000           // 5 seconds (5,000 milliseconds) - Usually takes 3 seconds so allowing 5 is plenty
#define T7ERASETIMEOUT 40000            // 40 seconds (40,000 milliseconds) - Usually takes less than 20 seconds so allowing 40 is plenty

extern bool t7_initialise();
extern bool t7_authenticate();
extern FILE * t7_file_open(const char* fname);
extern bool t7_dump(bool blockmode);
extern bool t7_erase();
extern bool t7_flash(FILE *, bool blockmode);
extern bool t7_recover(FILE *);
bool t7_flash_segment(FILE *, uint32_t address, uint32_t size, bool blockmode);
extern bool t7_reset();
/* global constants */
//#define init_msg        { 0x3F, 0x81, 0x00, 0x11, 0x02, 0x40, 0x00, 0x00 }

// ask_header_trionic7

//#define query           { 0x40, 0xA1, 0x02, 0x1A, 0x00, 0x00, 0x00, 0x00 }
//#define ack             { 0x40, 0xA1, 0x3F, 0x00, 0x00, 0x00, 0x00, 0x00 }

// ask_header2_trionic7

//#define query           { 0x40, 0xA1, 0x02, 0x1A, 0x00, 0x00, 0x00, 0x00 }
//#define ack             { 0x40, 0xA1, 0x3F, 0x00, 0x00, 0x00, 0x00, 0x00 }


// authenticate_trionic7

#define security_msg        { 0x40, 0xA1, 0x02, 0x27, 0x05, 0x00, 0x00, 0x00 }
#define security_msg_reply  { 0x40, 0xA1, 0x04, 0x27, 0x06, 0x00, 0x00, 0x00 }
#define ack                 { 0x40, 0xA1, 0x3F, 0x00, 0x00, 0x00, 0x00, 0x00 }
 

// erase_trionic7

//#define erase_msg1      { 0x40, 0xA1, 0x02, 0x31, 0x52, 0x00, 0x00, 0x00 }
//#define erase_msg2      { 0x40, 0xA1, 0x02, 0x31, 0x53, 0x00, 0x00, 0x00 }
//#define confirm_msg     { 0x40, 0xA1, 0x01, 0x3E, 0x00, 0x00, 0x00, 0x00 }


// program_trionic7

//#define jump_msg1a          { 0x41, 0xA1, 0x08, 0x34, 0x00, 0x00, 0x00, 0x00 }    // 0x000000 length=0x07B000
#define jump_msg1b          { 0x00, 0xA1, 0x07, 0xB0, 0x00, 0x00, 0x00, 0x00 }
#define jump_msg2a          { 0x41, 0xA1, 0x08, 0x34, 0x07, 0xFF, 0x00, 0x00 }    // 0x07FF00 length=0x000100
#define jump_msg2b          { 0x00, 0xA1, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00 }
#define end_data_msg        { 0x40, 0xA1, 0x01, 0x37, 0x00, 0x00, 0x00, 0x00 }
#define exit_diag_msg       { 0x40, 0xA1, 0x02, 0x31, 0x54, 0x00, 0x00, 0x00 }
#define req_diag_result_msg { 0x3F, 0x81, 0x01, 0x33, 0x02, 0x40, 0x00, 0x00 }  // 220h
#define ack                 { 0x40, 0xA1, 0x3F, 0x00, 0x00, 0x00, 0x00, 0x00 }        // 266h

// program_trionic7_tis

//#define jump_msg1a          { 0x41, 0xA1, 0x08, 0x34, 0x00, 0x00, 0x00, 0x00 }    // 0x000000 length=0x070000
//#define jump_msg1b          { 0x00, 0xA1, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00 }
//#define jump_msg2a          { 0x41, 0xA1, 0x08, 0x34, 0x07, 0xFF, 0x00, 0x00 }    // 0x07FF00 length=0x000100
//#define jump_msg2b          { 0x00, 0xA1, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00 }
//#define end_data_msg        { 0x40, 0xA1, 0x01, 0x37, 0x00, 0x00, 0x00, 0x00 }
//#define exit_diag_msg       { 0x40, 0xA1, 0x02, 0x31, 0x54, 0x00, 0x00, 0x00 }
//#define req_diag_result_msg { 0x3F, 0x81, 0x01, 0x33, 0x02, 0x40, 0x00, 0x00 }  // 220h
//#define ack                 { 0x40, 0xA1, 0x3F, 0x00, 0x00, 0x00, 0x00, 0x00 }        // 266h


// verify_trionic7
//#define init_msg        { 0x20, 0x81, 0x00, 0x11, 0x02, 0x42, 0x00, 0x00 }
//#define end_data_msg    { 0x40, 0xA1, 0x01, 0x82, 0x00, 0x00, 0x00, 0x00 }
//#define jump_msg1a      { 0x41, 0xA1, 0x08, 0x2C, 0xF0, 0x03, 0x00, 0xEF }    // 0x000000 length=0xEF
//#define jump_msg1b      { 0x00, 0xA1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }
//#define post_jump_msg   { 0x40, 0xA1, 0x01, 0x3E, 0x00, 0x00, 0x00, 0x00 }
//#define data_msg        { 0x40, 0xA1, 0x02, 0x21, 0xF0, 0x00, 0x00, 0x00 }
//#define ack             { 0x40, 0xA1, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00 }


#endif