#include "mbed.h"
#include "MODSERIAL.h"
MODSERIAL pc(USBTX, USBRX);
DigitalOut DirectionPin1(D4);
DigitalOut DirectionPin2(D7);
PwmOut PwmPin1(D5);
PwmOut PwmPin2(D6);
DigitalIn Knop1(D2);
AnalogIn pot1 (A5);
AnalogIn pot2 (A4);

Ticker mycontrollerTicker1;
Ticker mycontrollerTicker2;
Ticker Velo1;
Ticker Velo2;

//const float maxVelocity=8.4; // in rad/s
volatile float referenceVelocity1 = 0.5; //dit is de gecentreerde waarde en dus de nulstand
volatile float referenceVelocity2 = 0.5;
   
void velocity1()
    {
            if ((pot1.read()>0.5f) || (Knop1 == true))//gezeik met die knop doet het niet ff uitzoeken nog
                {
                // Clockwise rotation
                referenceVelocity1 = (pot1.read()-0.5f) * 2.0f; 
                }
            
            else if (pot1.read() == 0.5f || !Knop1 == (pot1.read()<0.5f))
            {
                referenceVelocity1 = pot1.read() * 0.0f; 
            } 
            
            else if (pot1.read() < 0.5f)
                {
                // Counterclockwise rotation      
                referenceVelocity1 = 2.0f * (pot1.read()-0.5f) ;
                }
    }
    
void velocity2()
    {
            if (pot2.read()>0.5f)
                {
                // Clockwise rotation
                referenceVelocity2 = (pot2.read()-0.5f) * 2.0f; 
                }
            
            else if (pot2.read() == 0.5f)
            {
                referenceVelocity2 = pot2.read() * 0.0f; 
            } 
            
            else if (pot2.read() < 0.5f)
                {
                // Counterclockwise rotation      
                referenceVelocity2 = 2.0f * (pot2.read()-0.5f) ;
                }
    }    
    
void motor1()
    {  
        float u = referenceVelocity1;
        DirectionPin1 = u < 0.0f;
        PwmPin1 = fabs(u);
    }

void motor2()
    {  
        float u = referenceVelocity2;
        DirectionPin2 = u > 0.0f;
        PwmPin2 = fabs(u);
    }

int main()
{
    pc.baud(115200);    
    PwmPin1.period_us(120); //60 microseconds pwm period, 16.7 kHz 
    mycontrollerTicker1.attach(motor1, 0.002);//500Hz
    Velo1.attach(velocity1, 0.002);
    mycontrollerTicker2.attach(motor2, 0.002);
    Velo2.attach(velocity2, 0.002);
    
    while(true)
    {        
    }
}