#include "mbed.h"

//Defines maquinas de estados
#define Esperando_Inicio 0
#define Codigo 1
#define Esperando_Desactivacion 2
#define Comparacion_Codigo 3
#define Termino 4
#define Control_Tiempo 5

//Entradas Digitales
DigitalIn Cable_0(PTE5);
DigitalIn Cable_1(PTE4);
DigitalIn Cable_2(PTE3);
DigitalIn Cable_3(PTE2);
DigitalIn Pulsador(PTB11);

//Salidas Digitales
DigitalOut Segmento_A(PTC7);
DigitalOut Segmento_B(PTC0);
DigitalOut Segmento_C(PTC3);
DigitalOut Segmento_D(PTC4);
DigitalOut Segmento_E(PTC5);
DigitalOut Segmento_F(PTC6);
DigitalOut Segmento_G(PTC10);
DigitalOut Habilitacion_Decenas(PTA4);
DigitalOut Habilitacion_Unidades(PTA12);

DigitalOut led_verde(LED_GREEN);
DigitalOut led_rojo(LED_RED);

//Variables
unsigned char combinacion[4],Estado_General=Esperando_Inicio,tiempo_rebote=0,a=0;
unsigned char estado_mostrar=0,decena=0,unidad=0,tiempo_decenas=0,tiempo_unidades=0,tiempo_exploto=0,b=0,flag=0,hab_parpadeo=0,estado_anterior=0;//display
unsigned char n;//Tiempo regresivo

//Ticker y sus funciones
Ticker T_rebote,tiempo,barrido;

void anti_rebote(void);
void tiempito(void);
void parpadeo(void);
void tiempo_barrido(void);

//Funciones
void mostrar(unsigned char n);//Funcion que muestra por los displays el nro que le pases
int main()
{
    //Habilito PullUp interno para los cables y el pulsador
    Cable_0.mode(PullUp);
    Cable_1.mode(PullUp);
    Cable_2.mode(PullUp);
    Cable_3.mode(PullUp);
    Pulsador.mode(PullUp);
    
    T_rebote.attach(&anti_rebote, 0.1);//Inicio timmer 1ms
    barrido.attach(&tiempo_barrido, 0.01);//inciio timmer para barrido de displays
    
    unsigned char codigo[4],for_a=0,antirebote_pulsador=0,antirebote_cables=0,antiprintf=0,habilitacion_pulsador=0;
    unsigned char hab_cable_3=0,hab_cable_2=0,hab_cable_1=0,hab_cable_0=0;
    
    led_verde=1;
    led_rojo=1;
    
    printf("-----Juego de la Bomba-----\n");//Introduccion al juego
    while(1)
    {
        switch (Estado_General)//Maquina de estados General del programa
        {
            default:
            
            case Esperando_Inicio://Se espera a que se active el juego
                hab_cable_3=0;
                hab_cable_2=0;
                hab_cable_1=0;
                hab_cable_0=0;
                led_verde=0;//Enciendo el led verde
                led_rojo=1;
                n=20;//Seteo el tiempo
                mostrar(n);
                for(a=0;a<4;a++)
                {
                    combinacion[a]=0;
                }
                a=0;
                antirebote_cables=0;
                while(antiprintf==0)
                {
                    printf("Pulse para iniciar\n");
                    antiprintf=1;
                    tiempo.detach();//reinicio los timmers
                }
                
                //Boton INICIO - si lo pulso incia el juego y cambio de estdado
                if(Pulsador==0 && antirebote_pulsador==0 && habilitacion_pulsador==1)
                {
                    tiempo_rebote=0;
                    antirebote_pulsador=1;
                }
                if(tiempo_rebote==1 && Pulsador==0 && habilitacion_pulsador==1)
                {
                    Estado_General=Codigo;//Cambio de estado
                    antirebote_pulsador=0;
                    antiprintf=0;
                    led_verde=1;
                    habilitacion_pulsador=0;
                }
                if(tiempo_rebote==1 && Pulsador==1 && habilitacion_pulsador==1)
                    antirebote_pulsador=0;
                    
                if(Pulsador==1 && antirebote_pulsador==0)
                {
                    tiempo_rebote=0;
                    antirebote_pulsador=1;
                }
                if(tiempo_rebote==1 && Pulsador==1)
                {
                    antirebote_pulsador=0;
                    habilitacion_pulsador=1;
                }
                if(tiempo_rebote==1 && Pulsador==0)
                    antirebote_pulsador=0;
                break;
            
            case Codigo://Se genera el codigo de desactivacion y se imprime
                mostrar(n);
                printf("-El CODIGO es: ");
                codigo[0]=rand()%4+1;
                do//Genero un codigo aleatorio de 4 digitos entre 1 y 4 sin repetir
                {
                    codigo[1]=rand()%4+1;
                }
                while(codigo[0]==codigo[1]);
                do
                {
                    codigo[2]=rand()%4+1;
                }
                while((codigo[0]==codigo[2]) || (codigo[1]==codigo[2]));
                do
                {
                    codigo[3]=rand()%4+1;
                }
                while((codigo[0]==codigo[3]) || (codigo[1]==codigo[3]) || (codigo[2]==codigo[3]));
                for(for_a=0;for_a<4;for_a++)
                {
                    printf("%i",codigo[for_a]);
                    if(for_a==3)
                        printf("\n");
                }
                Estado_General=Esperando_Desactivacion;//Una vez generado el codigo cambio de estado
                tiempo.attach(&tiempito, 1);//Inicia la cuenta regresiva
                break;
                
            case Esperando_Desactivacion://Se desactiva la bomba
                mostrar(n);
                //Cable 0
                if(Cable_0==1 && antirebote_cables==0 && hab_cable_0==0)
                {
                    tiempo_rebote=0;
                    antirebote_cables=1;
                    hab_cable_0=1;
                }
                if(Cable_0==1 && antirebote_cables==1 && tiempo_rebote==1)
                {
                    combinacion[a]=1;
                    Estado_General=Comparacion_Codigo;
                    a++;
                    antirebote_cables=0;
                }
                if(Cable_0==0 && antirebote_cables==1 && tiempo_rebote==1)
                {
                    antirebote_cables=0;
                    hab_cable_0=0;
                }   
                //Cable 1
                if(Cable_1==1 && antirebote_cables==0 && hab_cable_1==0)
                {
                    tiempo_rebote=0;
                    antirebote_cables=2;
                    hab_cable_1=1;
                }
                if(Cable_1==1 && antirebote_cables==2 && tiempo_rebote==1)
                {
                    combinacion[a]=2;
                    Estado_General=Comparacion_Codigo;
                    a++;
                    antirebote_cables=0;
                }
                if(Cable_1==0 && antirebote_cables==2 && tiempo_rebote==1)
                {
                    antirebote_cables=0;
                    hab_cable_1=0;
                }
                
                //Cable 2
                if(Cable_2==1 && antirebote_cables==0 && hab_cable_2==0)
                {
                    tiempo_rebote=0;
                    antirebote_cables=3;
                    hab_cable_2=1;
                }
                if(Cable_2==1 && antirebote_cables==3 && tiempo_rebote==1)
                {
                    combinacion[a]=3;
                    Estado_General=Comparacion_Codigo;
                    a++;
                    antirebote_cables=0;
                }
                if(Cable_2==0 && antirebote_cables==3 && tiempo_rebote==1)
                {
                    antirebote_cables=0;
                    hab_cable_2=0;
                }
                
                //Cable 3
                if(Cable_3==1 && antirebote_cables==0 && hab_cable_3==0)
                {
                    tiempo_rebote=0;
                    antirebote_cables=4;
                    hab_cable_3=1;
                }
                if(Cable_3==1 && antirebote_cables==4 && tiempo_rebote==1)
                {
                    combinacion[a]=4;
                    Estado_General=Comparacion_Codigo;
                    a++;
                    antirebote_cables=0;
                }
                if(Cable_3==0 && antirebote_cables==4 && tiempo_rebote==1)
                {
                    antirebote_cables=0;
                    hab_cable_3=0;
                }
                
                //Boton Para RESET - si se pulsa vuelvo a Esperando Inicio
                if(Pulsador==0 && antirebote_pulsador==0 && habilitacion_pulsador==1)
                {
                    tiempo_rebote=0;
                    antirebote_pulsador=1;
                }
                if(tiempo_rebote==1 && Pulsador==0 && habilitacion_pulsador==1)
                {
                    Estado_General=Esperando_Inicio;//Reseteo y vuelvo al estado inicial
                    antirebote_pulsador=0;
                    antiprintf=0;
                    printf("RESET\n");
                    habilitacion_pulsador=0;
                }
                if(tiempo_rebote==1 && Pulsador==1 && habilitacion_pulsador==1)
                    antirebote_pulsador=0;
                
                if(Pulsador==1 && antirebote_pulsador==0)
                {
                    tiempo_rebote=0;
                    antirebote_pulsador=1;
                }
                if(tiempo_rebote==1 && Pulsador==1)
                {
                    antirebote_pulsador=0;
                    habilitacion_pulsador=1;
                }
                if(tiempo_rebote==1 && Pulsador==0)
                    antirebote_pulsador=0;                
                break;
                    
            case Comparacion_Codigo://comparo el codigo con la combinacion
                if(combinacion[a-1]!=codigo[a-1])//Si el cable es incorrecto perdes
                {
                    printf("\n-----PERDISTE-----\n");
                    Estado_General=Termino;
                }
                if(combinacion[a-1]== codigo[a-1])//si es correcto seguis jugando
                    Estado_General=Esperando_Desactivacion;
                if((a==4) && (Estado_General==Esperando_Desactivacion))//si sacas el ultimo cable y es correcto ganas
                {
                    printf("\n-----GANASTE-----\n");
                    Estado_General=Termino;
                }
                break;
            
            case Termino://Hago parpadear el diaplay y el led correspondiente - espero boton para volver a inicio
                mostrar(n);
                while(antiprintf==0)
                {
                    printf("Conecte todos los cables\nPulse para iniciar de nuevo\n\n");
                    tiempo.detach();//freno el tiempo donde haya quedado
                    tiempo.attach(&parpadeo, 0.2);//inicio el parpadeo
                    antiprintf=1;
                }
                if((b%2)==1 && hab_parpadeo==0)
                {
                    estado_mostrar=5;
                    if(a==4)
                      led_verde=0;
                    if(a!=4)
                        led_rojo=0;
                    hab_parpadeo=1;
                }
                if((b%2)==0 && hab_parpadeo==1)
                {
                    estado_mostrar=1;
                    if(a==4)
                      led_verde=1;
                    if(a!=4)
                        led_rojo=1;
                    hab_parpadeo=0;
                }
                if(b==10)
                {
                    tiempo.detach();
                    led_verde=1;
                    led_rojo=1;
                    b=0;
                }
                if(Pulsador==0 && antirebote_pulsador==0 && habilitacion_pulsador==1)
                {
                    tiempo_rebote=0;
                    antirebote_pulsador=1;
                }
                if(tiempo_rebote==1 && Pulsador==0 && habilitacion_pulsador==1)
                {
                    Estado_General=Esperando_Inicio;//Vuelvo al estado de inicio
                    antirebote_pulsador=0;
                    antiprintf=0;
                }
                if(tiempo_rebote==1 && Pulsador==1 && habilitacion_pulsador==1)
                    antirebote_pulsador=0;
                    
                if(Pulsador==1 && antirebote_pulsador==0)
                {
                    tiempo_rebote=0;
                    antirebote_pulsador=1;
                }
                if(tiempo_rebote==1 && Pulsador==1)
                {
                    antirebote_pulsador=0;
                    habilitacion_pulsador=1;
                }
                if(tiempo_rebote==1 && Pulsador==0)
                    antirebote_pulsador=0;  
            break;
        }//sw
    }//while
}//main


void anti_rebote(void)//cada 1ms
{
  tiempo_rebote++;
  if(tiempo_rebote==10)
    tiempo_rebote=0;
}

void tiempito(void)//Cuenta regresiva cada 1 seg
{
    n--;
    if(n==0)
    {
        printf("\nPERDISTE\n");
        Estado_General=Termino;
        a=0;       
    }
}

void parpadeo(void)
{
    b++;
}

void tiempo_barrido(void)
{
    if(estado_mostrar==2)
        if(tiempo_decenas == 0)//if del demonio
            tiempo_decenas++;
    if(estado_mostrar==4)
        if(tiempo_unidades == 0)//if del demonio
            tiempo_unidades++;
}

void mostrar(unsigned char n)//Funcion que muestra por los displays el nro que le pases
{
    switch (estado_mostrar)
    {
        default:
        
        case 0:
            estado_anterior=0;
            decena=n/10;
            unidad=n%10;
            Habilitacion_Decenas=1;
            Habilitacion_Unidades=1;
            estado_mostrar=1;
            break;
            
        case 1:
            estado_anterior=1;
            if(decena==0)
            {
                Segmento_A=1;
                Segmento_B=1;
                Segmento_C=1;
                Segmento_D=1;
                Segmento_E=1;
                Segmento_F=1;
                Segmento_G=0;
            }
            if(decena==1)
            {
                Segmento_A=0;
                Segmento_B=1;
                Segmento_C=1;
                Segmento_D=0;
                Segmento_E=0;
                Segmento_F=0;
                Segmento_G=0;
            }
            if(decena==2)
            {
                Segmento_A=1;
                Segmento_B=1;
                Segmento_C=0;
                Segmento_D=1;
                Segmento_E=1;
                Segmento_F=0;
                Segmento_G=1; 
            }
            if(decena==3)
            {
                Segmento_A=1;
                Segmento_B=1;
                Segmento_C=1;
                Segmento_D=1;
                Segmento_E=0;
                Segmento_F=0;
                Segmento_G=1; 
            }
            estado_mostrar=2;
            break;
        
        case 2:
            estado_anterior=2;
            Habilitacion_Decenas=0;
            Habilitacion_Unidades=1;
            if(tiempo_decenas==1)
            {
                tiempo_decenas=0;
                estado_mostrar=3;
                Habilitacion_Decenas=1;
                Habilitacion_Unidades=1;
            }
            break;
            
        case 3:
            estado_anterior=3;
            if(unidad==0)
            {
                Segmento_A=1;
                Segmento_B=1;
                Segmento_C=1;
                Segmento_D=1;
                Segmento_E=1;
                Segmento_F=1;
                Segmento_G=0;
            }
            if(unidad==1)
            {
                Segmento_A=0;
                Segmento_B=1;
                Segmento_C=1;
                Segmento_D=0;
                Segmento_E=0;
                Segmento_F=0;
                Segmento_G=0; 
            }
            if(unidad==2)
            {
                Segmento_A=1;
                Segmento_B=1;
                Segmento_C=0;
                Segmento_D=1;
                Segmento_E=1;
                Segmento_F=0;
                Segmento_G=1; 
            }
            if(unidad==3)
            {
                Segmento_A=1;
                Segmento_B=1;
                Segmento_C=1;
                Segmento_D=1;
                Segmento_E=0;
                Segmento_F=0;
                Segmento_G=1;
            }
            if(unidad==4)
            {
                Segmento_A=0;
                Segmento_B=1;
                Segmento_C=1;
                Segmento_D=0;
                Segmento_E=0;
                Segmento_F=1;
                Segmento_G=1; 
            }
            if(unidad==5)
            {
                Segmento_A=1;
                Segmento_B=0;
                Segmento_C=1;
                Segmento_D=1;
                Segmento_E=0;
                Segmento_F=1;
                Segmento_G=1;   
            }
            if(unidad==6)
            {
                Segmento_A=1;
                Segmento_B=0;
                Segmento_C=1;
                Segmento_D=1;
                Segmento_E=1;
                Segmento_F=1;
                Segmento_G=1; 
            }
            if(unidad==7)
            {
                Segmento_A=1;
                Segmento_B=1;
                Segmento_C=1;
                Segmento_D=0;
                Segmento_E=0;
                Segmento_F=0;
                Segmento_G=0; 
            }
            if(unidad==8)
            {
                Segmento_A=1;
                Segmento_B=1;
                Segmento_C=1;
                Segmento_D=1;
                Segmento_E=1;
                Segmento_F=1;
                Segmento_G=1; 
            }
            if(unidad==9)
            {
                Segmento_A=1;
                Segmento_B=1;
                Segmento_C=1;
                Segmento_D=0;
                Segmento_E=0;
                Segmento_F=1;
                Segmento_G=1;  
            }
            estado_mostrar=4;
            break;

        case 4:
            estado_anterior=4;
            Habilitacion_Decenas=1;
            Habilitacion_Unidades=0;
            if(tiempo_unidades==1)
            {
                tiempo_unidades=0;
                estado_mostrar=0;
            }
            break;
            
        case 5:
            Habilitacion_Decenas=1;
            Habilitacion_Unidades=1;
            break;
    }//sw
}//funcion