#include "mbed.h"
#include "DS1820.h"//Libreria para medir el sensor de temp

//Defines Estados
#define Medicion_RPM_Max 0
#define Lazo_Cerrado 1
#define Lazo_Abierto 2

DigitalIn CoolerIn(PTE5);//Entrada sensor Hall
DigitalIn Pulsador(PTC0);//Entrada Pulsador

AnalogIn Preset(PTB3);//Entrada analogica del preset

DigitalOut azul(LED_BLUE);
DigitalOut rojo(LED_RED);
DigitalOut verde(LED_GREEN);

PwmOut CoolerOut(PTE20);//La salida tiene que variar entre 1.0 y 0.0

unsigned char t=0,n=0,HabilitacionMedicion=0;

Ticker seg,micro;

void segundos(void);//mediciones y printf
void micro_segundos(void);//antirebote pulsador
unsigned int calculo_RPM(unsigned int pulsos);//funcion que calcula las RPM

Serial serial(USBTX, USBRX);//Comunicacion con PC
 
int main()
{
    Pulsador.mode(PullUp);//Habilitamos pull up interno para el pulsador
    
    unsigned char Estado_General=0,habCoolerIn=0,antirebote_pulsador=0,habilitacion_pulsador=0,hab=0,hab_max=0;
    unsigned int pulsos=0,RPM=0,RPM_Max=0,Velocidad=0;
    float Temperatura=0,Valor_Preset=0,Velocidad_Real=1;
    
    DS1820  ds1820(PTC7);//Entre parentesis va el nombre del pin que recive los datos    
    ds1820.begin();//Inicio el sensor de Temp
    
    seg.attach(&segundos, 1);//Inicio Ticker 1 seg
    micro.attach(&micro_segundos, 0.1);//Inicio Ticker 100uS
    
    azul=1;
    rojo=1;
    verde=1;

        while(1)
        {
            switch (Estado_General)//Maquina de estados General del Programa
            {
                default://En caso de un estado incierto voy a Medicion_RPM_Max que es el estado de reset
   
                case Medicion_RPM_Max://Mido las RPM maximas del cooler conectado
                    CoolerOut=1;
                    if(CoolerIn==1 && habCoolerIn==1)//cuento las vueltas del cooler
                    {
                        pulsos++;
                        habCoolerIn=0;   
                    }
                    if(CoolerIn==0 && habCoolerIn==0)
                    {
                        habCoolerIn=1;   
                    }
                    //Parpadeo Azul y Blanco
                    if(t%2==0 && hab==0)
                    {
                        printf("Midiendo...\n");
                        azul=0;
                        rojo=1;
                        verde=1;
                        hab=1;
                    }
                    if(t%2!=0 && hab==1)
                    {
                        printf("Midiendo..\n");
                        azul=0;
                        rojo=0;
                        verde=0;
                        hab=0;
                    }
                    
                    if(t==4 && hab_max==0)//Dejo un margen de tiempo para asegurar el regimen permanente
                    {
                        pulsos=0;
                        hab_max=1;
                    }
                    if(t==7 && hab_max==1)//cada 3 seg calculo las RPM
                    {
                        RPM_Max=calculo_RPM(pulsos);
                        pulsos=0;
                        hab_max=2;
                    }
                    if(t==10 && hab_max==2)//Lo hago 2 veces y promedio para estar seguro
                    {
                        RPM_Max=(RPM_Max + calculo_RPM(pulsos))/2;//Necesito este dato para los calculos que voy a realizar
                        pulsos=0;
                        t=0;
                        Estado_General=Lazo_Cerrado;//Termina la medicion asi q voy estado lazo cerrado
                        printf("===Medicion Finalizada===\n");
                        printf("RPM Maxima: %i rpm\n",RPM_Max);
                        printf("\n======Lazo Cerrado======\n");
                        azul=1;
                        rojo=1;
                        verde=1;
                        hab_max=0;
                    }
                    break;
//------------------------------------------------------------------------------------
                case Lazo_Cerrado://Controlo las RPM del cooler en funcion de la temperatura (en lazo cerrado)
                    verde=0;
                    if(CoolerIn==1 && habCoolerIn==1)//cuento las vueltas del cooler
                    {
                        pulsos++;
                        habCoolerIn=0;   
                    }
                    if(CoolerIn==0 && habCoolerIn==0)
                    {
                        habCoolerIn=1;   
                    }
                    
                    if(t==3)//cada 3 seg calculo las RPM y ajusto la velocidad de salida
                    {
                        RPM=calculo_RPM(pulsos);
                        pulsos=0;
                        t=0;
                        if(RPM<Velocidad && Velocidad_Real<1)//Control de RPM en lazo cerrado
                        {
                            if((Velocidad-RPM)<400 && Velocidad_Real<0.9)
                                Velocidad_Real=Velocidad_Real+0.01;
                            if((Velocidad-RPM)>400)
                                Velocidad_Real=Velocidad_Real+0.1;
                        }
                        if(RPM>Velocidad)
                        {
                            if((RPM-Velocidad)<400)
                                Velocidad_Real=Velocidad_Real-0.01;
                            if((RPM-Velocidad)>400)
                                Velocidad_Real=Velocidad_Real-0.1;
                        }
                        //Cada 3 seg imprimo por pantalla los datos
                        printf("\nTemperatura: %.2f\nRPM: %i\n",Temperatura,RPM);
                        printf("RPM Ideal: %i\nPWM Cooler: %.2f\n",Velocidad,Velocidad_Real);
                    }
                    
                    if(HabilitacionMedicion==0)//Cada 1 segundo mido el sensor y calculo la velocidad a la que deberia girar
                    {
                        ds1820.startConversion();//Empieza la conversion de temperatura
                        Temperatura=ds1820.read();//Lees el valor de temperatura
                        Velocidad=(Temperatura-20)*((RPM_Max-400)/50)+400;//Velocidad en RPM a la q deberia girar el cooler - Responde a la tabla de valores
                        if(Temperatura>=70)//Si es mayor a 70 se clava al max
                        {
                            Velocidad=RPM_Max; 
                        }
                        if(Temperatura<=20)//Si es menor a 20 se clava en 400 RPM
                        {
                            Velocidad=400; 
                        }
                        CoolerOut=Velocidad_Real;//Fijo un PWM al cooler en funcion a lo controlado
                        HabilitacionMedicion=1;
                    }
                    
                    //Pulsador - si lo puslo cambio de modo
                    if(Pulsador==0 && antirebote_pulsador==0 && habilitacion_pulsador==1)
                    {
                        n=0;
                        antirebote_pulsador=1;
                    }
                    if(n==1 && Pulsador==0 && habilitacion_pulsador==1)//Cambio de estado
                    {
                        antirebote_pulsador=0;
                        habilitacion_pulsador=0;
                        Estado_General=Lazo_Abierto;
                        t=0;
                        printf("\n======Lazo Abierto======\n");
                        azul=1;
                        rojo=1;
                        verde=1;
                    }
                    if(n==1 && Pulsador==1 && habilitacion_pulsador==1)
                        antirebote_pulsador=0;
                    if(Pulsador==1 && antirebote_pulsador==0)
                    {
                        n=0;
                        antirebote_pulsador=1;
                    }
                    if(n==1 && Pulsador==1)
                    {
                        antirebote_pulsador=0;
                        habilitacion_pulsador=1;
                    }
                    if(n==1 && Pulsador==0)
                        antirebote_pulsador=0;
                        
                    break;
//------------------------------------------------------------------------------------
                case Lazo_Abierto://La velocidad del cooler depende del Preset
                    rojo=0;
                    if(CoolerIn==1 && habCoolerIn==1)//cuento las vueltas del cooler
                    {
                        pulsos++;
                        habCoolerIn=0;   
                    }
                    if(CoolerIn==0 && habCoolerIn==0)
                    {
                        habCoolerIn=1;   
                    }
                    
                    if(t==3)//cada 3 seg calculo las RPM
                    {
                        RPM=calculo_RPM(pulsos);
                        pulsos=0;
                        t=0;
                    }
                    
                    if(HabilitacionMedicion==0)//Cada 1 segundo mido el preset y ajusto la salida
                    {
                        Valor_Preset=Preset.read();
                        CoolerOut=Valor_Preset;//Ajusto la velocidad de salida
                        printf("\nPreset: %.0f\nRPM: %i\n",Valor_Preset*100,RPM);//Muestro los datos
                        HabilitacionMedicion=1;
                    }
                    
                    //Pulsador - si lo pulso cambio a lazo cerrado
                    if(Pulsador==0 && antirebote_pulsador==0 && habilitacion_pulsador==1)
                    {
                        n=0;
                        antirebote_pulsador=1;
                    }
                    if(n==1 && Pulsador==0 && habilitacion_pulsador==1)//Cambio de estado
                    {
                        antirebote_pulsador=0;
                        habilitacion_pulsador=0;
                        Estado_General=Lazo_Cerrado;
                        t=0;
                        printf("\n======Lazo Cerrado======\n");
                        azul=1;
                        rojo=1;
                        verde=1;
                    }
                    if(n==1 && Pulsador==1 && habilitacion_pulsador==1)
                        antirebote_pulsador=0;
                    if(Pulsador==1 && antirebote_pulsador==0)
                    {
                        n=0;
                        antirebote_pulsador=1;
                    }
                    if(n==1 && Pulsador==1)
                    {
                        antirebote_pulsador=0;
                        habilitacion_pulsador=1;
                    }
                    if(n==1 && Pulsador==0)
                        antirebote_pulsador=0;
                        
                    break;
                    
            }//SW
        }//while
}//main

void segundos(void)
{
    t++;
    HabilitacionMedicion=0;
}

void micro_segundos(void)
{
    if(n==0)
        n++;   
}

unsigned int calculo_RPM(unsigned int pulsos)
{
    return (pulsos*10);//Pulsos * 10 porque medimos durante 3 seg y cada 2 pulsos 1 vuelta
}