/***********************************
name:   Pwm_Tutorial_Bertl16
author: Julian Koller
description:
-> Motor Enable ist als PwOut definiert
-> Pulsweite kann beliebig Verändert werden.
-> Bert fährt 3sec gerade aus und dann wieder zurück
***********************************/


#include <mbed.h>
 
//Definition der Motoren
DigitalOut Von (P2_13);
PwmOut MotorL_EN(P1_19);
DigitalOut MotorL_REVERSE(P2_14);
DigitalOut MotorL_FORWARD(P2_15);
 
PwmOut MotorR_EN(P2_19);
DigitalOut MotorR_REVERSE(P2_21);
DigitalOut MotorR_FORWARD(P2_20);

int main()
{
    Von = 1; //Motorspannung V auf on
    
    //Pwm = Pulse Width Modulation
    //Periodendauer wird angegeben wie lange der Motor maximal Strom bekommen soll.
    //Geringere Werte = geschmeidiger Motorlauf. 10ms = extrem runder lauf. 100ms = runder lauf. 1000ms = es laggt
    //Periodendauer = 10ms = 100%. Pulsweite = 2ms = 20% von 10ms == 20% Motorleistung :D eZ
    MotorR_EN.period_ms(10); //Periodendauer = immer 100% egal welcher Wert gesetzt wurde
    MotorL_EN.period_ms(10); //Periodendauer = immer 100% egal welcher Wert gesetzt wurde
    MotorL_EN.pulsewidth_ms(2); //Pulsweite (T-on time) in ms die der Motor Strom bekommen soll
    MotorR_EN.pulsewidth_ms(2); //Pulsweite (T-on time) in ms die der Motor Strom bekommen soll
    //So einfach is ds. Ende
    
    do
    {
        MotorR_FORWARD = MotorL_FORWARD = 1; //Ganz normal Motor einschalten
        wait(3); //3sec warten
        MotorR_FORWARD = MotorL_FORWARD = 0; //Und wieder aus
        wait(1); //1sec warten
        MotorR_REVERSE = MotorL_REVERSE = 1; //Wieder Retour
        wait(3); //3sec warten
        MotorR_REVERSE = MotorL_REVERSE = 0; //Und wieder aus
        wait(1); //1sec warten
    } while(1);
}

//Ende