#include "TLC5940.h"

TLC5940::TLC5940(PinName mosi, PinName miso, PinName sck, PinName xlat, PinName blank, PinName gsclk)
{
    _spi = new SPI(mosi, miso, sck);
    _xlat = new DigitalOut(xlat);
    _blank = new DigitalOut(blank);
    _gsclk = new PwmOut(gsclk);
    _t = new Ticker();
    
    // Setup SPI
    _spi->format(12,0);
    _spi->frequency(5000000);
    
    //Turn off GSCLK
    _gsclk->write(0.0f);
    _gsclk->period_us(5);
    
    // Reset to 0
    for(int i = 0; i < 16; i++)
    {
           gs_data[i] = 4095;
           int whoami = _spi->write(4095);
    }
        
    _xlat->write(1);
    _xlat->write(0);
}

void TLC5940::setServo(int ch, int val)
{
    gs_data[15-ch] = val;
}

void TLC5940::flush()
{
    for(int i = 0; i < 16; i++){
        _spi->write(gs_data[i]);
    }
    
    _xlat->write(1);
    _xlat->write(0);
}

void TLC5940::run()
{
    _gsclk->write(0.5f);
    _t->attach_us(this, &TLC5940::refresh, 5*4096);
}

void TLC5940::refresh()
{
    _blank->write(1);
    _blank->write(0);
} 