#include "mbed.h"
#include "BV4205.h"

BV4205::BV4205(PinName sda, PinName scl, int devaddr)
{
    device = devaddr;
    adc = new I2C(sda, scl);

    // Set SCL freq to 75Khz
    adc->frequency(75000);

    // Reset device.
    adc->start();
    adc->write(device);
    adc->write(0x95);
    adc->stop();

    // Enable ADC.
    adc->start();
    adc->write(device);
    adc->write(0x05);
    adc->write(0x01);
    adc->stop();

    // Start Autoscan.
    adc->start();
    adc->write(device);
    adc->write(0x06);
    adc->write(0x01);
    adc->stop();
}

int BV4205::readChannel(int ch)
{
    if(ch >= 0 && ch <= 9) 
    {
        adc->start();
        adc->write(device);
        adc->write(0x07);
        adc->write(ch*2);
        adc->start();
        adc->write(device+1);
        wait_us(50);
        int H = adc->read(1);
        int L = adc->read(0);
        adc->stop();
        return (H<<8 | L);
    } else
        return 0;
}

int BV4205::readRange(int minch, int maxch, int *array)
{
    if(minch >= 0 && minch <= 9 && maxch >= 0 && maxch <= 9 && maxch>=minch ) 
    {
        adc->start();
        adc->write(device);
        adc->write(0x07);
        adc->write(minch*2);
        adc->start();
        adc->write(device+1);
        wait_us(50);
        
        int i = 0;
        while(i < maxch-minch)
        {
            int H = adc->read(1);
            int L = adc->read(1);
            array[i] = (H<<8 | L);
            i++;
        }
        int H = adc->read(1);
        int L = adc->read(0);
        adc->stop();
        array[i] = (H<<8 | L);
        return 1;
    } else
        return 0;
}
